/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.SimpleViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;

public class LineLayoutProvider
extends AbstractLayoutProvider {
    private static final Insets DEFAULT_PADDING = new Insets(30, 30, 30, 30);
    private boolean horizontal = true;

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        Iterator iterEditParts = selectedObjects.iterator();
        ArrayList<View> views = new ArrayList<View>(selectedObjects.size());
        HashMap<View, ShapeEditPart> viewsToEditPartMap = new HashMap<View, ShapeEditPart>();
        while (iterEditParts.hasNext()) {
            Object next = iterEditParts.next();
            if (next instanceof ShapeEditPart && !(next instanceof IBorderItemEditPart)) {
                ShapeEditPart shapeEditPart = (ShapeEditPart)next;
                View view = shapeEditPart.getNotationView();
                viewsToEditPartMap.put(view, shapeEditPart);
                views.add(view);
                continue;
            }
            iterEditParts.remove();
        }
        ViewOrdering viewOrdering = ViewOrderingHint.getInstance().consumeViewOrdering(this.getContainerEditPart(selectedObjects).getNotationView());
        if (viewOrdering == null) {
            viewOrdering = new SimpleViewOrdering();
        }
        viewOrdering.setViews(views);
        List<View> sortedViews = viewOrdering.getSortedViews();
        ArrayList<ShapeEditPart> sortedEditParts = new ArrayList<ShapeEditPart>(sortedViews.size());
        ListIterator<View> iterSortedViews = sortedViews.listIterator();
        while (iterSortedViews.hasNext()) {
            View currentView = (View)iterSortedViews.next();
            ShapeEditPart currentEditPart = (ShapeEditPart)viewsToEditPartMap.get(currentView);
            sortedEditParts.add(currentEditPart);
        }
        return this.createNodeChangeBoundCommands(sortedEditParts);
    }

    protected Command createNodeChangeBoundCommands(List<ShapeEditPart> sortedNodes) {
        CompoundCommand result = new CompoundCommand();
        Iterator<ShapeEditPart> iterEditParts = sortedNodes.iterator();
        int currentX = 0;
        while (iterEditParts.hasNext()) {
            ShapeEditPart shapeEditPart = iterEditParts.next();
            if (shapeEditPart instanceof IBorderItemEditPart) continue;
            View view = shapeEditPart.getNotationView();
            double scale = 1.0;
            if (shapeEditPart.getRoot() instanceof DiagramRootEditPart) {
                ZoomManager zoomManager = ((DiagramRootEditPart)shapeEditPart.getRoot()).getZoomManager();
                scale = zoomManager.getZoom();
            }
            Point ptOldLocation = shapeEditPart.getFigure().getBounds().getLocation();
            int locationX = this.horizontal ? currentX + this.getPadding().left : this.getPadding().left;
            int locationY = this.horizontal ? this.getPadding().top : currentX + this.getPadding().top;
            Point ptLocation = new Point(locationX, locationY);
            Dimension delta = ptLocation.getDifference(ptOldLocation);
            Request existingRequest = this.findRequest(view, (Object)"move");
            int step = 0;
            if (existingRequest == null) {
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
                request.setEditParts((EditPart)shapeEditPart);
                request.setMoveDelta((Point)new PrecisionPoint((double)delta.width * scale, (double)delta.height * scale));
                request.setLocation((Point)new PrecisionPoint((double)ptLocation.x * scale, (double)ptLocation.y * scale));
                step = this.horizontal ? this.getBounds((IGraphicalEditPart)shapeEditPart).width : this.getBounds((IGraphicalEditPart)shapeEditPart).height;
                Command cmd = this.buildCommandWrapper((Request)request, (EditPart)shapeEditPart);
                if (cmd != null && cmd.canExecute()) {
                    result.add(cmd);
                }
            } else if (existingRequest instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)existingRequest;
                changeBoundsRequest.setMoveDelta((Point)new PrecisionPoint((double)delta.width * scale, (double)delta.height * scale));
                changeBoundsRequest.setLocation((Point)new PrecisionPoint((double)ptLocation.x * scale, (double)ptLocation.y * scale));
                step = this.horizontal ? this.getBounds((IGraphicalEditPart)shapeEditPart).width : this.getBounds((IGraphicalEditPart)shapeEditPart).height;
            }
            currentX += this.horizontal ? step + this.getPadding().right + this.getPadding().left : step + this.getPadding().bottom + this.getPadding().top;
            EditPart container = shapeEditPart.getParent();
            while (container instanceof CompartmentEditPart) {
                container = container.getParent();
            }
            if (!(container instanceof ShapeEditPart)) continue;
            ShapeEditPart containerEditPart = (ShapeEditPart)container;
            int minWidth = this.horizontal ? (this.getPadding().left + this.getPadding().right) * sortedNodes.size() + this.getNodeMaxWidth(sortedNodes) * sortedNodes.size() : this.getPadding().left + this.getNodeMaxWidth(sortedNodes) + this.getPadding().right;
            int minHeight = this.horizontal ? this.getPadding().top + this.getNodeMaxHeight(sortedNodes) + this.getPadding().bottom : (this.getPadding().top + this.getPadding().bottom) * sortedNodes.size() + this.getNodeMaxHeight(sortedNodes) * sortedNodes.size();
            Dimension minDimension = new Dimension(minWidth, minHeight);
            Dimension difference = minDimension.getShrinked(containerEditPart.getFigure().getBounds().getSize());
            if (difference.width <= 0 && difference.height <= 0) continue;
            Request existingContainerRequest = this.findRequest((IGraphicalEditPart)containerEditPart, (Object)"resize");
            this.createChangeBoundsCommand(result, existingContainerRequest, containerEditPart, difference, scale);
        }
        return result;
    }

    private void createChangeBoundsCommand(CompoundCommand compoundCommand, Object existingContainerRequest, ShapeEditPart containerEditPart, Dimension difference, double scale) {
        if (existingContainerRequest == null) {
            ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest();
            changeBoundsRequest.setEditParts((EditPart)containerEditPart);
            changeBoundsRequest.setResizeDirection(20);
            changeBoundsRequest.setSizeDelta(new Dimension((int)((double)difference.width * scale), (int)((double)difference.height * scale)));
            changeBoundsRequest.setLocation(new Point(0, 0));
            changeBoundsRequest.setType((Object)"resize");
            Command cmd = this.buildCommandWrapper((Request)changeBoundsRequest, (EditPart)containerEditPart);
            if (cmd.canExecute()) {
                compoundCommand.add(cmd);
            }
        } else if (existingContainerRequest instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)existingContainerRequest;
            changeBoundsRequest.setResizeDirection(20);
            changeBoundsRequest.setSizeDelta(new Dimension((int)((double)difference.width * scale), (int)((double)difference.height * scale)));
        }
    }

    protected int getNodeMaxWidth(List<ShapeEditPart> nodes) {
        int max = -1;
        for (ShapeEditPart shapeEditPart : nodes) {
            List<Request> existingRequest = this.getViewsToChangeBoundsRequest().get(shapeEditPart.getNotationView());
            int width = shapeEditPart.getFigure().getBounds().width;
            if (existingRequest instanceof ChangeBoundsRequest) {
                width += ((ChangeBoundsRequest)existingRequest).getSizeDelta().width;
            }
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    protected int getNodeMaxHeight(List<ShapeEditPart> nodes) {
        int max = -1;
        for (ShapeEditPart shapeEditPart : nodes) {
            int height = this.getBounds((IGraphicalEditPart)shapeEditPart).height;
            if (height <= max) continue;
            max = height;
        }
        return max;
    }

    @Override
    public boolean provides(IOperation operation) {
        View cview = this.getContainer(operation);
        if (cview == null) {
            return false;
        }
        IAdaptable layoutHint = ((ILayoutNodeOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "DEFAULT".equals(layoutType);
    }

    public Insets getPadding() {
        return DEFAULT_PADDING;
    }

    protected IGraphicalEditPart getContainerEditPart(List<EditPart> selectedObjects) {
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            return (IGraphicalEditPart)selectedObjects.iterator().next().getParent();
        }
        return null;
    }
}

