/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.internal.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.sirius.ui.editor.SessionEditor;
import org.eclipse.sirius.ui.editor.api.pages.AbstractSessionEditorPage;
import org.eclipse.sirius.ui.editor.api.pages.PageProvider;
import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;
import org.eclipse.ui.forms.editor.FormEditor;

public class PageOrderer {
    public List<AbstractSessionEditorPage> getOrderedPages(List<PageProvider> pageProviders, SessionEditor editor, List<AbstractSessionEditorPage> alreadyInitializedPages, ResourceSetChangeEvent event) {
        ArrayList<AbstractSessionEditorPage> pagesToKeep = new ArrayList<AbstractSessionEditorPage>();
        ArrayList<PagePositioning> pagePositioningElements = new ArrayList<PagePositioning>();
        HashMap<String, PagePositioning> pageIdToPageMap = new HashMap<String, PagePositioning>();
        this.initializePagePositioning(pageProviders, editor, alreadyInitializedPages, pagesToKeep, pagePositioningElements, pageIdToPageMap, event);
        this.positionPagesRegardingOthers(pagePositioningElements, pageIdToPageMap);
        HashSet<PagePositioning> replacedPages = new HashSet<PagePositioning>();
        this.replacePages(pagePositioningElements, pageIdToPageMap, replacedPages);
        LinkedList<PagePositioning> newPageOrdered = this.linkAllPageRoot(pagePositioningElements, replacedPages);
        List<AbstractSessionEditorPage> pagesResult = newPageOrdered.stream().map(pageP -> pageP.page).collect(Collectors.toList());
        return pagesResult;
    }

    private LinkedList<PagePositioning> linkAllPageRoot(List<PagePositioning> pagePositioningElements, Set<PagePositioning> replacedPages) {
        LinkedList<PagePositioning> newPageOrdered = new LinkedList<PagePositioning>();
        for (PagePositioning pagePositioning : pagePositioningElements) {
            if (replacedPages.contains(pagePositioning)) continue;
            if (pagePositioning.leftPortPage == null && pagePositioning.rightPortPage != null) {
                this.recursivelyAddLinkedPages(newPageOrdered, pagePositioning);
                continue;
            }
            if (pagePositioning.leftPortPage == null && pagePositioning.rightPortPage == null) {
                newPageOrdered.addLast(pagePositioning);
                continue;
            }
            if (pagePositioning.leftPortPage.rightPortPage == pagePositioning) continue;
            newPageOrdered.addLast(pagePositioning);
        }
        return newPageOrdered;
    }

    private void replacePages(List<PagePositioning> pagePositioningElements, Map<String, PagePositioning> pageIdToPageMap, Set<PagePositioning> replacedPages) {
        for (PagePositioning pagePositioning : pagePositioningElements) {
            PagePositioning replacedPage;
            if (pagePositioning.replacePortPageId == null || (replacedPage = pageIdToPageMap.get(pagePositioning.replacePortPageId)) == null) continue;
            pagePositioning.replacePortPage = replacedPage;
            if (replacedPage.leftPortPage != null) {
                if (pagePositioning.leftPortPage == null) {
                    pagePositioning.leftPortPage = replacedPage.leftPortPage;
                } else {
                    PagePositioning leftMostPage = this.getLeftMostPage(replacedPage);
                    leftMostPage.leftPortPage = pagePositioning.leftPortPage;
                    pagePositioning.leftPortPage.rightPortPage = leftMostPage;
                    pagePositioning.leftPortPage = replacedPage.leftPortPage;
                    replacedPage.leftPortPage.rightPortPage = pagePositioning;
                }
            }
            if (replacedPage.rightPortPage != null) {
                if (pagePositioning.rightPortPage == null) {
                    pagePositioning.rightPortPage = replacedPage.rightPortPage;
                } else {
                    PagePositioning rightMostPage = this.getRightMostPage(replacedPage);
                    rightMostPage.rightPortPage = pagePositioning.rightPortPage;
                    pagePositioning.rightPortPage.leftPortPage = rightMostPage;
                    pagePositioning.rightPortPage = replacedPage.rightPortPage;
                    replacedPage.rightPortPage.leftPortPage = pagePositioning;
                }
            }
            replacedPages.add(pagePositioning.replacePortPage);
        }
    }

    private PagePositioning getRightMostPage(PagePositioning pagePositioning) {
        if (pagePositioning.rightPortPage == null) {
            return pagePositioning;
        }
        return this.getLeftMostPage(pagePositioning.rightPortPage);
    }

    private PagePositioning getLeftMostPage(PagePositioning pagePositioning) {
        if (pagePositioning.leftPortPage == null) {
            return pagePositioning;
        }
        return this.getLeftMostPage(pagePositioning.leftPortPage);
    }

    private void positionPagesRegardingOthers(List<PagePositioning> pagePositioningElements, Map<String, PagePositioning> pageIdToPageMap) {
        for (PagePositioning pagePositioning : pagePositioningElements) {
            PagePositioning targetPagePositioning;
            if (pagePositioning.leftPortPageId != null && (targetPagePositioning = pageIdToPageMap.get(pagePositioning.leftPortPageId)) != null) {
                pagePositioning.leftPortPage = targetPagePositioning;
                if (targetPagePositioning.rightPortPage != null) {
                    targetPagePositioning.rightPortPage.leftPortPage = pagePositioning;
                    pagePositioning.rightPortPage = targetPagePositioning.rightPortPage;
                }
                targetPagePositioning.rightPortPage = pagePositioning;
            }
            if (pagePositioning.rightPortPageId == null || (targetPagePositioning = pageIdToPageMap.get(pagePositioning.rightPortPageId)) == null) continue;
            pagePositioning.rightPortPage = targetPagePositioning;
            if (targetPagePositioning.leftPortPage != null) {
                targetPagePositioning.leftPortPage.rightPortPage = pagePositioning;
                pagePositioning.leftPortPage = targetPagePositioning.leftPortPage;
            }
            targetPagePositioning.leftPortPage = pagePositioning;
        }
    }

    private void initializePagePositioning(List<PageProvider> pageProviders, SessionEditor editor, List<AbstractSessionEditorPage> alreadyInitializedPages, List<AbstractSessionEditorPage> pagesToKeep, List<PagePositioning> pagePositioningElements, Map<String, PagePositioning> pageIdToPageMap, ResourceSetChangeEvent event) {
        Set alreadyInitializedPagesId = alreadyInitializedPages.stream().map(page -> page.getId()).collect(Collectors.toSet());
        for (PageProvider pageProvider : pageProviders) {
            Map<String, Supplier<AbstractSessionEditorPage>> pagesToAdd;
            boolean providePages;
            List notifications = event != null ? event.getNotifications() : Collections.emptyList();
            NotificationFilter filterForInitialCondition = pageProvider.getFilterForPageRequesting();
            boolean bl = providePages = notifications.isEmpty() || notifications.stream().anyMatch(notification -> filterForInitialCondition == null ? true : filterForInitialCondition.matches(notification));
            if (providePages && (pagesToAdd = pageProvider.getPages(editor)) != null) {
                for (Map.Entry<String, Supplier<AbstractSessionEditorPage>> pageEntry : pagesToAdd.entrySet()) {
                    if (alreadyInitializedPagesId.contains(pageEntry.getKey())) continue;
                    AbstractSessionEditorPage page2 = pageEntry.getValue().get();
                    page2.initialize((FormEditor)editor);
                    PagePositioning pagePositioning = new PagePositioning();
                    pageIdToPageMap.put(page2.getId(), pagePositioning);
                    pagePositioningElements.add(pagePositioning);
                    Optional<PageProviderRegistry.PositioningKind> positioningKind = page2.getPositioning();
                    Optional<String> locationId = page2.getLocationId();
                    if (positioningKind.isPresent() && locationId.isPresent()) {
                        this.setPortsId(positioningKind.get(), locationId.get(), pagePositioning);
                    }
                    pagePositioning.page = page2;
                }
            }
            if (pagesToKeep.size() == alreadyInitializedPages.size()) continue;
            for (AbstractSessionEditorPage page3 : alreadyInitializedPages) {
                if (!pageProvider.provides(page3.getId(), editor)) continue;
                pagesToKeep.add(page3);
                PagePositioning pagePositioning = new PagePositioning();
                pageIdToPageMap.put(page3.getId(), pagePositioning);
                Optional<PageProviderRegistry.PositioningKind> positioningKind = page3.getPositioning();
                Optional<String> locationId = page3.getLocationId();
                if (positioningKind.isPresent() && locationId.isPresent()) {
                    this.setPortsId(positioningKind.get(), locationId.get(), pagePositioning);
                }
                pagePositioning.page = page3;
                pagePositioningElements.add(pagePositioning);
            }
        }
    }

    private void setPortsId(PageProviderRegistry.PositioningKind positioningKind, String targetPageId, PagePositioning pagePositioning) {
        if (positioningKind != null && !targetPageId.isEmpty()) {
            switch (positioningKind) {
                case BEFORE: {
                    pagePositioning.rightPortPageId = targetPageId;
                    break;
                }
                case AFTER: {
                    pagePositioning.leftPortPageId = targetPageId;
                    break;
                }
                case REPLACE: {
                    pagePositioning.replacePortPageId = targetPageId;
                    break;
                }
            }
        }
    }

    private void recursivelyAddLinkedPages(LinkedList<PagePositioning> newPageOrdered, PagePositioning pagePositioning) {
        if (pagePositioning.rightPortPage != null) {
            this.recursivelyAddLinkedPages(newPageOrdered, pagePositioning.rightPortPage);
        }
        if (!newPageOrdered.contains(pagePositioning)) {
            newPageOrdered.addFirst(pagePositioning);
        }
    }

    private final class PagePositioning {
        AbstractSessionEditorPage page;
        String leftPortPageId;
        String rightPortPageId;
        String replacePortPageId;
        PagePositioning leftPortPage;
        PagePositioning rightPortPage;
        PagePositioning replacePortPage;

        private PagePositioning() {
        }

        public String toString() {
            String toString = "Page: " + ((Object)((Object)this.page)).getClass().getSimpleName();
            toString = toString + (String)(this.leftPortPageId != null ? "\nLeft id: " + this.leftPortPageId : "");
            toString = toString + (String)(this.rightPortPageId != null ? "\nRight id: " + this.rightPortPageId : "");
            toString = toString + (String)(this.replacePortPageId != null ? "\nReplace id: " + this.replacePortPageId : "");
            return toString;
        }
    }
}

