/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.properties.WizardModelOperation;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.ui.properties.internal.EditingContextAdapterWrapper;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.ui.properties.internal.wizard.PropertiesWizardPage;

public class PropertiesWizard
extends Wizard {
    private WizardModelOperation wizardModelOperation;
    private EEFView eefView;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private ModelAccessor modelAccessor;
    private CommandContext context;
    private Session session;
    private Consumer<IStatus> consumer;

    public PropertiesWizard(WizardModelOperation wizardModelOperation, EEFView eefView, IInterpreter interpreter, IVariableManager variableManager, ModelAccessor modelAccessor, CommandContext context, Session session) {
        this.wizardModelOperation = wizardModelOperation;
        this.eefView = eefView;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        this.modelAccessor = modelAccessor;
        this.context = context;
        this.session = session;
        this.setNeedsProgressMonitor(false);
        this.setHelpAvailable(false);
        this.evaluateExpression(this.variableManager.getVariables(), this.wizardModelOperation.getWindowTitleExpression(), String.class).ifPresent(arg_0 -> ((PropertiesWizard)this).setWindowTitle(arg_0));
        this.configureModelChangeRefresh();
    }

    private void configureModelChangeRefresh() {
        EditingContextAdapter editingContextAdapter = this.eefView.getContextAdapter();
        if (editingContextAdapter instanceof EditingContextAdapterWrapper) {
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            this.consumer = status -> Optional.ofNullable(this.getContainer().getCurrentPage()).filter(PropertiesWizardPage.class::isInstance).map(PropertiesWizardPage.class::cast).ifPresent(this::refreshWizard);
            wrapper.addPerformedModelChangeConsumer(this.consumer);
        }
    }

    private void refreshWizard(PropertiesWizardPage wizardPage) {
        wizardPage.refresh();
        this.getContainer().updateButtons();
    }

    public void addPages() {
        this.eefView.getPages().forEach(this::createPage);
    }

    private void createPage(EEFPage eefPage) {
        String title = this.evaluateExpression(this.variableManager.getVariables(), this.wizardModelOperation.getTitleExpression(), String.class).orElse("");
        String description = this.evaluateExpression(this.variableManager.getVariables(), this.wizardModelOperation.getDescriptionExpression(), String.class).orElse("");
        ImageDescriptor imageDescriptor = null;
        this.addPage((IWizardPage)new PropertiesWizardPage(this.wizardModelOperation.toString(), title, description, imageDescriptor, this.wizardModelOperation, eefPage));
    }

    private <T> Optional<T> evaluateExpression(Map<String, Object> variables, String expression, Class<T> clazz) {
        return Optional.ofNullable(expression).filter(exp -> !exp.isEmpty()).map(exp -> this.interpreter.evaluateExpression(this.variableManager.getVariables(), exp)).filter(IEvaluationResult::success).map(IEvaluationResult::getValue).filter(clazz::isInstance).map(clazz::cast);
    }

    public boolean performCancel() {
        this.aboutToBeClosed();
        return super.performCancel();
    }

    private void aboutToBeClosed() {
        Optional.ofNullable(this.getContainer().getCurrentPage()).filter(PropertiesWizardPage.class::isInstance).map(PropertiesWizardPage.class::cast).ifPresent(PropertiesWizardPage::aboutToBeHidden);
    }

    public boolean performFinish() {
        this.aboutToBeClosed();
        EditingContextAdapter editingContextAdapter = this.eefView.getContextAdapter();
        if (editingContextAdapter instanceof EditingContextAdapterWrapper) {
            EditingContextAdapterWrapper wrapper = (EditingContextAdapterWrapper)editingContextAdapter;
            wrapper.removePerformedModelChangeConsumer(this.consumer);
        }
        try {
            this.getContainer().run(false, false, monitor -> Optional.ofNullable(this.wizardModelOperation.getInitialOperation()).flatMap(initialOperation -> Optional.ofNullable(initialOperation.getFirstModelOperations())).ifPresent(modelOperation -> {
                ICommandTask task = new TaskHelper(this.modelAccessor, SiriusPlugin.getDefault().getUiCallback()).buildTaskFromModelOperation(this.context.getCurrentTarget(), modelOperation);
                SiriusCommand command = new SiriusCommand(this.session.getTransactionalEditingDomain(), "SiriusToolServices#executeOperation");
                command.getTasks().add(task);
                try {
                    if (command.canExecute()) {
                        command.execute();
                    }
                }
                finally {
                    command.dispose();
                }
            }));
        }
        catch (InterruptedException | InvocationTargetException e) {
            SiriusUIPropertiesPlugin.getPlugin().error(e.getMessage(), e);
        }
        return true;
    }
}

