/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

public final class BusyIndicator
extends Label {
    private static final int MARGIN = 0;
    private static final int IMAGE_COUNT = 1;
    private Image[] imageCache;
    private Image image;
    private boolean busy;

    public BusyIndicator(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BusyIndicator.this.clearImages();
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, 0);
        if (this.image != null) {
            Rectangle ibounds = this.image.getBounds();
            size.x = ibounds.width;
            size.y = ibounds.height;
        }
        if (this.isBusy()) {
            Rectangle bounds = this.getImage(0).getBounds();
            size.x = Math.max(size.x, bounds.width);
            size.y = Math.max(size.y, bounds.height);
        }
        size.x += 0;
        size.y += 0;
        return size;
    }

    public boolean forceFocus() {
        return false;
    }

    public Image getImage() {
        return this.isBusy() ? this.getImage(0) : this.image;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public synchronized void setBusy(boolean busy) {
        if (this.busy == busy) {
            return;
        }
        this.busy = busy;
    }

    public void setImage(Image image) {
        if (image != this.image && !this.isDisposed()) {
            this.image = image;
            this.redraw();
        }
    }

    private ImageDescriptor createImageDescriptor(String relativePath) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui.forms");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        if (url == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private Image getImage(int index) {
        if (this.imageCache == null) {
            this.imageCache = new Image[1];
        }
        if (this.imageCache[index] == null) {
            ImageDescriptor descriptor = this.createImageDescriptor("$nl$/icons/progress/ani/progress.gif");
            this.imageCache[index] = descriptor.createImage();
        }
        return this.imageCache[index];
    }

    private void clearImages() {
        if (this.imageCache != null) {
            int index = 0;
            while (index < 1) {
                if (this.imageCache[index] != null) {
                    this.imageCache[index] = null;
                }
                ++index;
            }
        }
    }
}

