/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.sync;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.internal.sync.doc.cola.ColaSynchronizationStrategyFactory;
import org.eclipse.ecf.internal.sync.doc.identity.IdentitySynchronizationStrategyFactory;
import org.eclipse.ecf.sync.doc.IDocumentSynchronizationStrategyFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.sync";
    private static Activator bundle;
    private ServiceRegistration colaServiceRegistration;
    private ServiceRegistration identityServiceRegistration;
    private BundleContext context;
    IdentitySynchronizationStrategyFactory identity;
    ColaSynchronizationStrategyFactory cola;
    private ServiceTracker adapterManagerTracker = null;
    private ServiceTracker logServiceTracker = null;

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new ServiceTracker(this.context, IAdapterManager.class.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        if (adapterManager == null) {
            Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, "Cannot get adapter manager", null));
        }
        return adapterManager;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public static Activator getDefault() {
        return bundle;
    }

    public void start(BundleContext ctxt) throws Exception {
        bundle = this;
        this.context = ctxt;
        this.identity = new IdentitySynchronizationStrategyFactory();
        this.cola = new ColaSynchronizationStrategyFactory();
        Properties identityServiceProps = new Properties();
        ((Dictionary)identityServiceProps).put("org.eclipse.ecf.type", "org.eclipse.ecf.sync.doc");
        ((Dictionary)identityServiceProps).put("org.eclipse.ecf.sync.provider", "org.eclipse.ecf.sync.doc.identity");
        this.identityServiceRegistration = this.context.registerService(IDocumentSynchronizationStrategyFactory.class.getName(), (Object)this.identity, (Dictionary)identityServiceProps);
        Properties colaServiceProps = new Properties();
        ((Dictionary)colaServiceProps).put("service.ranking", 1);
        ((Dictionary)colaServiceProps).put("org.eclipse.ecf.type", "org.eclipse.ecf.sync.doc");
        ((Dictionary)colaServiceProps).put("org.eclipse.ecf.sync.provider", "org.eclipse.ecf.internal.sync.doc.cola");
        this.colaServiceRegistration = this.context.registerService(IDocumentSynchronizationStrategyFactory.class.getName(), (Object)this.cola, (Dictionary)colaServiceProps);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.colaServiceRegistration != null) {
            this.colaServiceRegistration.unregister();
            this.colaServiceRegistration = null;
        }
        if (this.identityServiceRegistration != null) {
            this.identityServiceRegistration.unregister();
            this.identityServiceRegistration = null;
        }
        if (this.identity != null) {
            this.identity.dispose();
            this.identity = null;
        }
        if (this.cola != null) {
            this.cola.dispose();
            this.cola = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        this.context = null;
        bundle = null;
    }
}

