/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.tcp.SSLClient;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;

public class SSLClientSOContainer
extends ClientSOContainer {
    int keepAlive = 0;
    public static final int DEFAULT_TCP_CONNECT_TIMEOUT = 30000;
    public static final String DEFAULT_COMM_NAME = SSLClient.class.getName();

    public SSLClientSOContainer(ISharedObjectContainerConfig config) {
        super(config);
    }

    public SSLClientSOContainer(ISharedObjectContainerConfig config, int ka) {
        super(config);
        this.keepAlive = ka;
    }

    @Override
    protected int getConnectTimeout() {
        return 30000;
    }

    @Override
    protected ISynchAsynchConnection createConnection(ID remoteSpace, Object data) throws ConnectionCreateException {
        this.debug("createClientConnection:" + remoteSpace + ":" + data);
        SSLClient conn = new SSLClient(this.receiver, this.keepAlive);
        return conn;
    }

    public static final void main(String[] args) throws Exception {
        SOContainerConfig config = new SOContainerConfig(IDFactory.getDefault().createGUID());
        SSLClientSOContainer container = new SSLClientSOContainer(config);
        ID serverID = IDFactory.getDefault().createStringID(SSLServerSOContainer.getDefaultServerURL());
        container.connect(serverID, null);
        Thread.sleep(200000L);
    }
}

