/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient5.win32;

import java.util.Map;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.KerberosSchemeFactory;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.win.WindowsNTLMSchemeFactory;
import org.apache.hc.client5.http.impl.win.WindowsNegotiateSchemeFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient5.HttpClientModifierAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component
public class Win32HttpClientConfigurationModifier
extends HttpClientModifierAdapter {
    public static final String ID = "org.eclipse.ecf.provider.filetransfer.httpclients5.win32";
    public static final String SERVICE_PRINCIPAL_NAME_ATTRIBUTE = "servicePrincipal";
    public static final String SERVICE_PRINCIPAL_NAME_PROPERTY = "org.eclipse.ecf.provider.filetransfer.httpclients5.win32.servicePrincipal";
    private String servicePrincipalName;

    public HttpClientBuilder modifyClient(HttpClientBuilder builder) {
        HttpClientBuilder winBuilder = builder == null ? HttpClientBuilder.create() : builder;
        Lookup<AuthSchemeFactory> authSchemeRegistry = this.createAuthSchemeRegistry();
        return winBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
    }

    public HttpClientContext modifyContext(HttpClientContext context) {
        Lookup<AuthSchemeFactory> authSchemeRegistry = context.getAuthSchemeRegistry();
        authSchemeRegistry = authSchemeRegistry == null ? this.createAuthSchemeRegistry() : this.modifyAuthSchemeRegistry(authSchemeRegistry);
        context.setAuthSchemeRegistry(authSchemeRegistry);
        return context;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    private Lookup<AuthSchemeFactory> createAuthSchemeRegistry() {
        return this.setWinAuthSchemes((RegistryBuilder<AuthSchemeFactory>)RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("Kerberos", (Object)KerberosSchemeFactory.DEFAULT)).build();
    }

    private Lookup<AuthSchemeFactory> modifyAuthSchemeRegistry(Lookup<AuthSchemeFactory> authSchemeRegistry) {
        RegistryBuilder builder = RegistryBuilder.create();
        String[] stringArray = new String[]{"Basic", "Digest", "Kerberos"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            AuthSchemeFactory provider = (AuthSchemeFactory)authSchemeRegistry.lookup(scheme);
            if (provider != null) {
                builder.register(scheme, (Object)provider);
            }
            ++n2;
        }
        if (authSchemeRegistry.lookup("Kerberos") == null) {
            builder.register("Kerberos", (Object)KerberosSchemeFactory.DEFAULT);
        }
        this.setWinAuthSchemes((RegistryBuilder<AuthSchemeFactory>)builder);
        return builder.build();
    }

    private RegistryBuilder<AuthSchemeFactory> setWinAuthSchemes(RegistryBuilder<AuthSchemeFactory> builder) {
        return builder.register("NTLM", (Object)new WindowsNTLMSchemeFactory(this.servicePrincipalName)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(this.servicePrincipalName));
    }

    @Activate
    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        this.servicePrincipalName = this.getServicePrincipalName(properties);
    }

    private String getServicePrincipalName(Map<?, ?> properties) {
        Object servicePrincipalValue = properties.get(SERVICE_PRINCIPAL_NAME_ATTRIBUTE);
        if (servicePrincipalValue != null) {
            return servicePrincipalValue.toString();
        }
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        if (bundle != null) {
            return bundle.getBundleContext().getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
        }
        return System.getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
    }

    public RequestConfig.Builder modifyRequestConfig(RequestConfig.Builder config, HttpClientContext context, Map<?, ?> options) {
        return null;
    }
}

