/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;

public abstract class AbstractRegistrySourceConnector
implements IRegistrySourceConnector {
    protected Set<IConnectorListener> listeners;
    private String identifier;
    private boolean includeInDefaultViews;

    public AbstractRegistrySourceConnector(String identifier, boolean includeInDefaultViews) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier must not be null!");
        this.identifier = identifier;
        this.includeInDefaultViews = includeInDefaultViews;
        this.listeners = Sets.newHashSet();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean includeSpecificationsInDefaultViews() {
        return this.includeInDefaultViews;
    }

    @Override
    public void addListener(IConnectorListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null!");
        boolean added = this.listeners.add(listener);
        if (added) {
            this.sendQuerySpecificationsToListener(listener);
        }
    }

    @Override
    public void removeListener(IConnectorListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null!");
        this.listeners.remove(listener);
    }

    protected abstract void sendQuerySpecificationsToListener(IConnectorListener var1);
}

