/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.surrogate.SurrogateQueryRegistry;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public class ExtensionBasedSurrogateQueryLoader {
    private static final String DUPLICATE_SURROGATE_QUERY = "Duplicate surrogate query definition %s for feature %s of EClass %s in package %s (FQN in map %s, contributing plug-ins %s, plug-in %s)";
    private Multimap<String, String> contributingPluginOfFeatureMap = HashMultimap.create();
    private Map<EStructuralFeature, PQueryProvider> contributedSurrogateQueries;
    private static final ExtensionBasedSurrogateQueryLoader INSTANCE = new ExtensionBasedSurrogateQueryLoader();

    public static ExtensionBasedSurrogateQueryLoader instance() {
        return INSTANCE;
    }

    public void loadKnownSurrogateQueriesIntoRegistry() {
        Map<EStructuralFeature, PQueryProvider> knownSurrogateQueryFQNs = this.getSurrogateQueryProviders();
        for (Map.Entry<EStructuralFeature, PQueryProvider> entry : knownSurrogateQueryFQNs.entrySet()) {
            EStructuralFeatureInstancesKey inputKey = new EStructuralFeatureInstancesKey(entry.getKey());
            SurrogateQueryRegistry.instance().registerSurrogateQueryForFeature((IInputKey)inputKey, (IProvider)entry.getValue());
        }
    }

    private Map<EStructuralFeature, PQueryProvider> getSurrogateQueryProviders() {
        if (this.contributedSurrogateQueries != null) {
            return this.contributedSurrogateQueries;
        }
        this.contributedSurrogateQueries = Maps.newHashMap();
        if (Platform.isRunning()) {
            ImmutableList config = ImmutableList.builder().add((Object[])Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.viatra.query.runtime.surrogatequeryemf")).build();
            for (IConfigurationElement e : config) {
                if (!e.isValid()) continue;
                this.processExtension(e);
            }
        }
        return this.contributedSurrogateQueries;
    }

    private void processExtension(IConfigurationElement el) {
        try {
            String packageUri = el.getAttribute("package-nsUri");
            String className = el.getAttribute("class-name");
            String featureName = el.getAttribute("feature-name");
            String queryFqn = el.getAttribute("query-fqn");
            if (queryFqn == null) {
                queryFqn = "";
            }
            PQueryProvider surrogateQueryProvider = new PQueryProvider(el);
            String contributorName = el.getContributor().getName();
            StringBuilder featureIdBuilder = new StringBuilder();
            Preconditions.checkState((packageUri != null ? 1 : 0) != 0, (Object)"Package NsURI cannot be null in extension");
            Preconditions.checkState((className != null ? 1 : 0) != 0, (Object)"Class name cannot be null in extension");
            Preconditions.checkState((featureName != null ? 1 : 0) != 0, (Object)"Feature name cannot be null in extension");
            EPackage pckg = EPackage.Registry.INSTANCE.getEPackage(packageUri);
            featureIdBuilder.append(packageUri);
            Preconditions.checkState((pckg != null ? 1 : 0) != 0, (String)"Package %s not found! (plug-in %s)", (Object[])new Object[]{packageUri, contributorName});
            EClassifier clsr = pckg.getEClassifier(className);
            featureIdBuilder.append("##").append(className);
            Preconditions.checkState((boolean)(clsr instanceof EClass), (String)"EClassifier %s does not exist in package %s! (plug-in %s)", (Object[])new Object[]{className, packageUri, contributorName});
            EClass cls = (EClass)clsr;
            EStructuralFeature feature = cls.getEStructuralFeature(featureName);
            featureIdBuilder.append("##").append(featureName);
            Preconditions.checkState((feature != null ? 1 : 0) != 0, (String)"Feature %s of EClass %s in package %s not found! (plug-in %s)", (Object[])new Object[]{featureName, className, packageUri, contributorName});
            PQueryProvider fqnInMap = this.contributedSurrogateQueries.get(feature);
            if (fqnInMap != null) {
                String duplicateSurrogateFormatString = DUPLICATE_SURROGATE_QUERY;
                Collection contributorPlugins = this.contributingPluginOfFeatureMap.get((Object)featureIdBuilder.toString());
                String duplicateSurrogateMessage = String.format(duplicateSurrogateFormatString, queryFqn, featureName, className, packageUri, fqnInMap, contributorPlugins, contributorName);
                throw new IllegalStateException(duplicateSurrogateMessage);
            }
            this.contributedSurrogateQueries.put(feature, surrogateQueryProvider);
            this.contributingPluginOfFeatureMap.put((Object)featureIdBuilder.toString(), (Object)contributorName);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(SurrogateQueryRegistry.class);
            logger.error((Object)"Surrogate query registration failed", (Throwable)e);
        }
    }

    private static final class PQueryProvider
    implements IProvider<PQuery> {
        private final IConfigurationElement element;
        private PQuery query;

        public PQueryProvider(IConfigurationElement element) {
            this.element = element;
            this.query = null;
        }

        public PQuery get() {
            try {
                if (this.query == null) {
                    this.query = (PQuery)this.element.createExecutableExtension("surrogate-query");
                }
                return this.query;
            }
            catch (CoreException e) {
                throw new IllegalArgumentException("Error initializing surrogate query", e);
            }
        }
    }
}

