/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.core.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.remote.internal.proxy.server.core.commands.AbstractServerCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public abstract class AbstractServerExecCommand
extends AbstractServerCommand {
    private final List<String> command;
    private final Map<String, String> env;
    private final boolean redirect;
    private final boolean appendEnv;
    private final String directory;
    private final InputStream stdinChan;
    private final OutputStream stdoutChan;
    private final OutputStream stderrChan;
    private final DataInputStream cmdStream;
    private final DataOutputStream resultStream;
    private Process proc;

    public AbstractServerExecCommand(List<String> command, Map<String, String> env, String directory, boolean redirect, boolean appendEnv, StreamChannel cmdChan, StreamChannel ioChan, StreamChannel errChan) {
        this.command = command;
        this.env = env;
        this.directory = directory;
        this.redirect = redirect;
        this.appendEnv = appendEnv;
        this.stdinChan = ioChan.getInputStream();
        this.stdoutChan = ioChan.getOutputStream();
        this.stderrChan = errChan != null ? errChan.getOutputStream() : this.stdoutChan;
        this.resultStream = new DataOutputStream(cmdChan.getOutputStream());
        this.cmdStream = new DataInputStream(cmdChan.getInputStream());
    }

    protected abstract Process doRun() throws IOException;

    protected abstract void doKill(Process var1);

    protected abstract void doSetTerminalSize(Process var1, int var2, int var3);

    protected List<String> getCommand() {
        return this.command;
    }

    protected Map<String, String> getEnv() {
        return this.env;
    }

    protected boolean isRedirect() {
        return this.redirect;
    }

    protected boolean isAppendEnv() {
        return this.appendEnv;
    }

    protected String getDirectory() {
        return this.directory;
    }

    @Override
    public void exec() throws ProxyException {
        new Thread(new CommandRunner()).start();
    }

    private Forwarder startForwarder(String name, InputStream in, OutputStream out) {
        Forwarder forwarder = new Forwarder(name, in, out);
        Thread thread = new Thread((Runnable)forwarder, forwarder.getName());
        thread.start();
        return forwarder;
    }

    private class CommandRunner
    implements Runnable {
        private CommandRunner() {
        }

        @Override
        public void run() {
            try {
                int exit = 0;
                try {
                    AbstractServerExecCommand.this.proc = AbstractServerExecCommand.this.doRun();
                    Forwarder stdoutFwd = AbstractServerExecCommand.this.startForwarder("stdout", AbstractServerExecCommand.this.proc.getInputStream(), AbstractServerExecCommand.this.stdoutChan);
                    Forwarder stderrFwd = null;
                    if (!AbstractServerExecCommand.this.redirect) {
                        stderrFwd = AbstractServerExecCommand.this.startForwarder("stderr", AbstractServerExecCommand.this.proc.getErrorStream(), AbstractServerExecCommand.this.stderrChan);
                    }
                    AbstractServerExecCommand.this.startForwarder("stdin", AbstractServerExecCommand.this.stdinChan, AbstractServerExecCommand.this.proc.getOutputStream());
                    new Thread((Runnable)new ProcMonitor(), "process monitor").start();
                    exit = AbstractServerExecCommand.this.proc.waitFor();
                    stdoutFwd.waitFor();
                    if (stderrFwd != null) {
                        stderrFwd.waitFor();
                    }
                }
                catch (IOException e) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(AbstractServerExecCommand.this.stderrChan));
                    try {
                        writer.write(e.getMessage());
                        writer.flush();
                    }
                    catch (IOException iOException) {}
                    exit = -1;
                }
                try {
                    AbstractServerExecCommand.this.resultStream.writeInt(exit);
                    AbstractServerExecCommand.this.resultStream.flush();
                }
                catch (IOException iOException) {}
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class Forwarder
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final String name;
        private boolean running = true;
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();

        public Forwarder(String name, InputStream in, OutputStream out) {
            this.name = name;
            this.in = new BufferedInputStream(in);
            this.out = new BufferedOutputStream(out);
        }

        @Override
        public void run() {
            byte[] buf = new byte[8192];
            try {
                while (this.running) {
                    int n = this.in.read(buf);
                    if (n > 0) {
                        this.out.write(buf, 0, n);
                        this.out.flush();
                    }
                    if (n >= 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            this.lock.lock();
            try {
                this.running = false;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public String getName() {
            return this.name;
        }

        /*
         * Exception decompiling
         */
        public synchronized void waitFor() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ProcMonitor
    implements Runnable {
        private ProcMonitor() {
        }

        @Override
        public void run() {
            try {
                switch (AbstractServerExecCommand.this.cmdStream.readByte()) {
                    case 0: {
                        AbstractServerExecCommand.this.doKill(AbstractServerExecCommand.this.proc);
                        break;
                    }
                    case 1: {
                        int cols = AbstractServerExecCommand.this.cmdStream.readInt();
                        int rows = AbstractServerExecCommand.this.cmdStream.readInt();
                        AbstractServerExecCommand.this.cmdStream.readInt();
                        AbstractServerExecCommand.this.cmdStream.readInt();
                        AbstractServerExecCommand.this.doSetTerminalSize(AbstractServerExecCommand.this.proc, cols, rows);
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }
}

