/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class JobIdPinTable {
    private final Map<String, ReentrantLock> map = Collections.synchronizedMap(new HashMap());

    public void pin(String jobId) {
        if (jobId == null) {
            return;
        }
        ReentrantLock lock = this.map.get(jobId);
        if (lock == null) {
            lock = new ReentrantLock();
        }
        lock.lock();
        this.map.put(jobId, lock);
    }

    public void release(String jobId) {
        if (jobId == null) {
            return;
        }
        ReentrantLock lock = this.map.get(jobId);
        if (lock != null && lock.isHeldByCurrentThread()) {
            lock.unlock();
            this.map.remove(jobId);
        }
    }
}

