/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.discovery;

import org.eclipse.core.runtime.Assert;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingElement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class MojoExecutionMappingConfiguration
implements ILifecycleMappingElement {
    private final MojoExecutionKey execution;
    private final PluginExecutionMetadata mapping;
    private final ILifecycleMappingRequirement requirement;

    public MojoExecutionMappingConfiguration(MojoExecutionKey execution, IPluginExecutionMetadata mapping) {
        this.execution = execution;
        this.mapping = (PluginExecutionMetadata)mapping;
        this.requirement = mapping == null ? new MojoExecutionMappingRequirement(execution) : (mapping.getAction() == PluginExecutionAction.configurator ? new ProjectConfiguratorMappingRequirement(execution, LifecycleMappingFactory.getProjectConfiguratorId(mapping)) : null);
    }

    public String getArtifactId() {
        return this.execution.getArtifactId();
    }

    public String getGoal() {
        return this.execution.getGoal();
    }

    public boolean isMapped() {
        return false;
    }

    public boolean isExtensionAvailable() {
        return false;
    }

    public MojoExecutionKey getMojoExecutionKey() {
        return this.execution;
    }

    public MojoExecutionKey getExecution() {
        return this.execution;
    }

    public PluginExecutionMetadata getMapping() {
        return this.mapping;
    }

    @Override
    public ILifecycleMappingRequirement getLifecycleMappingRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        int hash = this.execution.hashCode();
        if (this.mapping != null) {
            hash = 17 * hash + this.mapping.getAction().hashCode();
            if (this.mapping.getAction() == PluginExecutionAction.configurator) {
                hash += LifecycleMappingFactory.getProjectConfiguratorId(this.mapping).hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        String otherConfiguratorId;
        String configuratorId;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MojoExecutionMappingConfiguration)) {
            return false;
        }
        MojoExecutionMappingConfiguration other = (MojoExecutionMappingConfiguration)obj;
        if (!this.execution.equals(other.execution)) {
            return false;
        }
        if (this.mapping == null) {
            return other.mapping == null;
        }
        if (other.mapping == null) {
            return false;
        }
        if (this.mapping.getAction() != other.mapping.getAction()) {
            return false;
        }
        return this.mapping.getAction() != PluginExecutionAction.configurator || MojoExecutionMappingConfiguration.eq(configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(this.mapping), otherConfiguratorId = LifecycleMappingFactory.getProjectConfiguratorId(other.mapping));
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static class MojoExecutionMappingRequirement
    implements ILifecycleMappingRequirement {
        private final MojoExecutionKey execution;
        private String executionId;
        private String packaging;

        public MojoExecutionMappingRequirement(MojoExecutionKey execution) {
            Assert.isNotNull((Object)execution);
            this.execution = new MojoExecutionKey(execution.getGroupId(), execution.getArtifactId(), execution.getVersion(), execution.getGoal(), null, null);
            this.executionId = execution.getExecutionId();
        }

        public MojoExecutionMappingRequirement(MojoExecutionKey execution, String packaging) {
            this(execution);
            this.packaging = packaging;
        }

        public int hashCode() {
            int hash = this.execution.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MojoExecutionMappingRequirement)) {
                return false;
            }
            MojoExecutionMappingRequirement other = (MojoExecutionMappingRequirement)obj;
            return this.execution.equals(other.execution);
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public MojoExecutionKey getExecution() {
            return this.execution;
        }

        public String getPackaging() {
            return this.packaging;
        }
    }

    public static class ProjectConfiguratorMappingRequirement
    implements ILifecycleMappingRequirement {
        private final MojoExecutionKey execution;
        private final String configuratorId;

        public ProjectConfiguratorMappingRequirement(MojoExecutionKey execution, String configuratorId) {
            this.execution = execution;
            this.configuratorId = configuratorId;
        }

        public int hashCode() {
            return this.configuratorId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProjectConfiguratorMappingRequirement)) {
                return false;
            }
            ProjectConfiguratorMappingRequirement other = (ProjectConfiguratorMappingRequirement)obj;
            return this.configuratorId.equals(other.configuratorId) && this.execution.equals(other.execution);
        }

        public MojoExecutionKey getExecution() {
            return this.execution;
        }

        public String getProjectConfiguratorId() {
            return this.configuratorId;
        }
    }
}

