/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;

public class HttpUtil {
    public static HttpClient createHttpClient(String baseUri) {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.useragent", (Object)"org.eclipse.epp.mpc.core");
        if (baseUri != null) {
            HttpUtil.configureProxy((HttpClient)client, baseUri);
        }
        return client;
    }

    public static void configureProxy(HttpClient client, String url) {
        IProxyData proxyData = ProxyHelper.getProxyData(url);
        if (proxyData != null && !"SOCKS".equals(proxyData.getType())) {
            HttpHost proxy = new HttpHost(proxyData.getHost(), proxyData.getPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (proxyData.isRequiresAuthentication()) {
                ((AbstractHttpClient)client).getCredentialsProvider().setCredentials(new AuthScope(proxyData.getHost(), proxyData.getPort()), (Credentials)new UsernamePasswordCredentials(proxyData.getUserId(), proxyData.getPassword()));
            }
        }
    }
}

