/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSBaseSearchable;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.SizeValidator;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;

public class FSSizeSearchable
extends FSBaseSearchable {
    private static final int OPTION_NOT_REMEMBER = 0;
    private static final int OPTION_SIZE_SMALL = 1;
    private static final int OPTION_SIZE_MEDIUM = 2;
    private static final int OPTION_SIZE_LARGE = 3;
    private static final int OPTION_SIZE_SPECIFIED = 4;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long SIZE_SMALL = 102400L;
    private static final long SIZE_MEDIUM = 0x100000L;
    private int choice;
    private int lowerSize;
    private int upperSize;
    private Button fBtnSizeNotRem;
    private Button fBtnSizeSmall;
    private Button fBtnSizeMedium;
    private Button fBtnSizeLarge;
    private Button fBtnSizeSpecified;
    private BaseEditBrowseTextControl txtSizeFrom;
    private BaseEditBrowseTextControl txtSizeTo;

    public void createAdvancedPart(TreeViewerSearchDialog dialog, Composite parent) {
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSSizeSearchable.this.optionChecked(e);
            }
        };
        Composite sizeComp = this.createSection(parent, Messages.FSSizeSearchable_WhatSize);
        sizeComp.setLayout((Layout)new GridLayout(5, false));
        this.fBtnSizeNotRem = new Button(sizeComp, 16);
        this.fBtnSizeNotRem.setText(Messages.FSSizeSearchable_DontRemember);
        this.fBtnSizeNotRem.setSelection(true);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        this.fBtnSizeNotRem.setLayoutData((Object)data);
        this.fBtnSizeNotRem.addSelectionListener((SelectionListener)l);
        this.fBtnSizeSmall = new Button(sizeComp, 16);
        this.fBtnSizeSmall.setText(Messages.FSSizeSearchable_Small);
        data = new GridData();
        data.horizontalSpan = 5;
        this.fBtnSizeSmall.setLayoutData((Object)data);
        this.fBtnSizeSmall.addSelectionListener((SelectionListener)l);
        this.fBtnSizeMedium = new Button(sizeComp, 16);
        this.fBtnSizeMedium.setText(Messages.FSSizeSearchable_Medium);
        data = new GridData();
        data.horizontalSpan = 5;
        this.fBtnSizeMedium.setLayoutData((Object)data);
        this.fBtnSizeMedium.addSelectionListener((SelectionListener)l);
        this.fBtnSizeLarge = new Button(sizeComp, 16);
        this.fBtnSizeLarge.setText(Messages.FSSizeSearchable_Large);
        data = new GridData();
        data.horizontalSpan = 5;
        this.fBtnSizeLarge.setLayoutData((Object)data);
        this.fBtnSizeLarge.addSelectionListener((SelectionListener)l);
        this.fBtnSizeSpecified = new Button(sizeComp, 16);
        this.fBtnSizeSpecified.setText(Messages.FSSizeSearchable_SpecifySize);
        data = new GridData();
        this.fBtnSizeSpecified.setLayoutData((Object)data);
        this.fBtnSizeSpecified.addSelectionListener((SelectionListener)l);
        Composite cmpFrom = new Composite(sizeComp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        cmpFrom.setLayout((Layout)layout);
        data = new GridData();
        cmpFrom.setLayoutData((Object)data);
        this.txtSizeFrom = new BaseEditBrowseTextControl(null);
        this.txtSizeFrom.setIsGroup(false);
        this.txtSizeFrom.setHasHistory(false);
        this.txtSizeFrom.setHideBrowseButton(true);
        this.txtSizeFrom.setParentControlIsInnerPanel(true);
        this.txtSizeFrom.setupPanel(cmpFrom);
        this.txtSizeFrom.setEnabled(false);
        this.txtSizeFrom.setEditFieldValidator((Validator)new SizeValidator());
        Text text = (Text)this.txtSizeFrom.getEditFieldControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSSizeSearchable.this.sizeModified();
            }
        });
        Label label = new Label(sizeComp, 0);
        label.setText(Messages.FSSizeSearchable_ToText);
        Composite cmpTo = new Composite(sizeComp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        cmpTo.setLayout((Layout)layout);
        data = new GridData();
        cmpTo.setLayoutData((Object)data);
        this.txtSizeTo = new BaseEditBrowseTextControl(null);
        this.txtSizeTo.setIsGroup(false);
        this.txtSizeTo.setHasHistory(false);
        this.txtSizeTo.setHideBrowseButton(true);
        this.txtSizeTo.setParentControlIsInnerPanel(true);
        this.txtSizeTo.setupPanel(cmpTo);
        this.txtSizeTo.setEnabled(false);
        this.txtSizeTo.setEditFieldValidator((Validator)new SizeValidator());
        text = (Text)this.txtSizeTo.getEditFieldControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSSizeSearchable.this.sizeModified();
            }
        });
        label = new Label(sizeComp, 0);
        label.setText(Messages.FSSizeSearchable_KBS);
    }

    protected void sizeModified() {
        this.fireOptionChanged();
    }

    public boolean isInputValid() {
        if (this.choice == 4 && this.txtSizeFrom != null && this.txtSizeTo != null) {
            boolean vFrom = this.txtSizeFrom.isValid();
            boolean vTo = this.txtSizeTo.isValid();
            if (vFrom) {
                String fromText = this.txtSizeFrom.getEditFieldControlText();
                this.lowerSize = Integer.parseInt(fromText);
            }
            if (vTo) {
                String toText = this.txtSizeTo.getEditFieldControlText();
                this.upperSize = Integer.parseInt(toText);
            }
            return vFrom && vTo;
        }
        return true;
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        boolean specified = false;
        if (src == this.fBtnSizeNotRem) {
            this.choice = 0;
        } else if (src == this.fBtnSizeSmall) {
            this.choice = 1;
        } else if (src == this.fBtnSizeMedium) {
            this.choice = 2;
        } else if (src == this.fBtnSizeLarge) {
            this.choice = 3;
        } else if (src == this.fBtnSizeSpecified) {
            this.choice = 4;
            specified = true;
        }
        if (this.txtSizeFrom != null) {
            this.txtSizeFrom.setEnabled(specified);
        }
        if (this.txtSizeTo != null) {
            this.txtSizeTo.setEnabled(specified);
        }
        this.fireOptionChanged();
    }

    public boolean match(Object element) {
        if (element instanceof IFSTreeNode) {
            IFSTreeNode node = (IFSTreeNode)element;
            switch (this.choice) {
                case 0: {
                    return true;
                }
                case 1: {
                    return node.getSize() <= 102400L;
                }
                case 2: {
                    return node.getSize() <= 0x100000L;
                }
                case 3: {
                    return node.getSize() > 0x100000L;
                }
                case 4: {
                    return node.getSize() >= (long)this.lowerSize && node.getSize() < (long)this.upperSize;
                }
            }
        }
        return false;
    }
}

