/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.CopyFailureListAction;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TestSessionLabelProvider;
import org.eclipse.jdt.internal.junit.ui.TestSessionTableContentProvider;
import org.eclipse.jdt.internal.junit.ui.TestSessionTreeContentProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.PageBook;

public class TestViewer {
    private final FailuresOnlyFilter fFailuresOnlyFilter = new FailuresOnlyFilter();
    private final IgnoredOnlyFilter fIgnoredOnlyFilter = new IgnoredOnlyFilter();
    private final TestRunnerViewPart fTestRunnerPart;
    private final Clipboard fClipboard;
    private PageBook fViewerbook;
    private TreeViewer fTreeViewer;
    private TestSessionTreeContentProvider fTreeContentProvider;
    private TestSessionLabelProvider fTreeLabelProvider;
    private TableViewer fTableViewer;
    private TestSessionTableContentProvider fTableContentProvider;
    private TestSessionLabelProvider fTableLabelProvider;
    private SelectionProviderMediator fSelectionProvider;
    private int fLayoutMode;
    private boolean fTreeHasFilter;
    private boolean fTableHasFilter;
    private TestRunSession fTestRunSession;
    private boolean fTreeNeedsRefresh;
    private boolean fTableNeedsRefresh;
    private HashSet<TestElement> fNeedUpdate;
    private TestCaseElement fAutoScrollTarget;
    private LinkedList<TestSuiteElement> fAutoClose;
    private HashSet<TestSuiteElement> fAutoExpand;

    public TestViewer(Composite parent, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        this.fClipboard = clipboard;
        this.fLayoutMode = 1;
        this.createTestViewers(parent);
        this.registerViewersRefresh();
        this.initContextMenu();
    }

    private void createTestViewers(Composite parent) {
        this.fViewerbook = new PageBook(parent, 0);
        this.fTreeViewer = new TreeViewer((Composite)this.fViewerbook, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeContentProvider = new TestSessionTreeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, 1);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.fTreeLabelProvider));
        this.fTableViewer = new TableViewer((Composite)this.fViewerbook, 772);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableContentProvider = new TestSessionTableContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fTableContentProvider);
        this.fTableLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart, 0);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ColoringLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.fTableLabelProvider));
        this.fSelectionProvider = new SelectionProviderMediator(new StructuredViewer[]{this.fTreeViewer, this.fTableViewer}, (StructuredViewer)this.fTreeViewer);
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)new TestSelectionListener());
        TestOpenListener testOpenListener = new TestOpenListener();
        this.fTreeViewer.getTree().addSelectionListener((SelectionListener)testOpenListener);
        this.fTableViewer.getTable().addSelectionListener((SelectionListener)testOpenListener);
        this.fTestRunnerPart.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        this.fViewerbook.showPage((Control)this.fTreeViewer.getTree());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestViewer.this.handleMenuAboutToShow(manager);
            }
        });
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSelectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)this.fViewerbook);
        this.fTreeViewer.getTree().setMenu(menu);
        this.fTableViewer.getTable().setMenu(menu);
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (!selection.isEmpty()) {
            TestElement testElement = (TestElement)selection.getFirstElement();
            if (testElement instanceof TestSuiteElement) {
                TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
                manager.add((IAction)this.getOpenTestAction(testSuiteElement));
                manager.add((IContributionItem)new Separator());
                if (!this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    this.addRerunActions(manager, testSuiteElement);
                }
            } else {
                TestCaseElement testCaseElement = (TestCaseElement)testElement;
                manager.add((IAction)this.getOpenTestAction(testCaseElement));
                manager.add((IContributionItem)new Separator());
                this.addRerunActions(manager, testCaseElement);
            }
            if (this.fLayoutMode == 1) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ExpandAllAction());
            }
        }
        if (this.fTestRunSession != null && this.fTestRunSession.getFailureCount() + this.fTestRunSession.getErrorCount() > 0) {
            if (this.fLayoutMode != 1) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new CopyFailureListAction(this.fTestRunnerPart, this.fClipboard));
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void addRerunActions(IMenuManager manager, TestCaseElement testCaseElement) {
        String className = testCaseElement.getClassName();
        String testMethodName = testCaseElement.getTestMethodName();
        String[] parameterTypes = testCaseElement.getParameterTypes();
        if (parameterTypes != null) {
            String paramTypesStr = Arrays.stream(parameterTypes).collect(Collectors.joining(","));
            testMethodName = String.valueOf(testMethodName) + "(" + paramTypesStr + ")";
        }
        if (this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
            manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_rerun, this.fTestRunnerPart, testCaseElement.getId(), className, testMethodName, testCaseElement.getDisplayName(), testCaseElement.getUniqueId(), "run"));
        } else {
            manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_run, this.fTestRunnerPart, testCaseElement.getId(), className, testMethodName, testCaseElement.getDisplayName(), testCaseElement.getUniqueId(), "run"));
            manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_debug, this.fTestRunnerPart, testCaseElement.getId(), className, testMethodName, testCaseElement.getDisplayName(), testCaseElement.getUniqueId(), "debug"));
        }
    }

    private void addRerunActions(IMenuManager manager, TestSuiteElement testSuiteElement) {
        String qualifiedName = null;
        String testMethodName = null;
        String testName = testSuiteElement.getTestName();
        IType testType = this.findTestClass((ITestElement)testSuiteElement, true);
        if (testType != null) {
            int index;
            qualifiedName = testType.getFullyQualifiedName();
            if (!qualifiedName.equals(testName) && (index = testName.indexOf(40)) > 0) {
                testMethodName = testName.substring(0, index);
            }
            String[] parameterTypes = testSuiteElement.getParameterTypes();
            if (testMethodName != null && parameterTypes != null) {
                String paramTypesStr = Arrays.stream(parameterTypes).collect(Collectors.joining(","));
                testMethodName = String.valueOf(testMethodName) + "(" + paramTypesStr + ")";
            }
        } else {
            String className;
            testType = this.findTestClass((ITestElement)testSuiteElement.getParent(), false);
            if (testType != null && !(qualifiedName = testType.getFullyQualifiedName()).equals(className = testSuiteElement.getSuiteTypeName())) {
                testMethodName = testName;
            }
        }
        if (qualifiedName != null) {
            manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_run, this.fTestRunnerPart, testSuiteElement.getId(), qualifiedName, testMethodName, testSuiteElement.getDisplayName(), testSuiteElement.getUniqueId(), "run"));
            manager.add((IAction)new RerunAction(JUnitMessages.RerunAction_label_debug, this.fTestRunnerPart, testSuiteElement.getId(), qualifiedName, testMethodName, testSuiteElement.getDisplayName(), testSuiteElement.getUniqueId(), "debug"));
        }
    }

    private IType findTestClass(ITestElement element, boolean checkOnlyCurrentElement) {
        ITestFinder finder = ((TestRunSession)element.getTestRunSession()).getTestRunnerKind().getFinder();
        if (ITestFinder.NULL.equals(finder)) {
            return null;
        }
        IJavaProject project = this.fTestRunnerPart.getLaunchedProject();
        if (project == null) {
            return null;
        }
        ITestElement current = element;
        while (current != null) {
            try {
                String className = null;
                if (current instanceof TestRoot) {
                    ILaunch launch = ((TestRunSession)element.getTestRunSession()).getLaunch();
                    if (launch != null) {
                        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                        className = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
                    }
                } else if (current instanceof TestElement) {
                    className = ((TestElement)current).getClassName();
                }
                if (className != null) {
                    IType type = project.findType(className);
                    if (type != null && finder.isTest(type)) {
                        return type;
                    }
                    if (checkOnlyCurrentElement) {
                        return null;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
            TestSuiteElement testSuiteElement = current = current instanceof TestElement ? ((TestElement)current).getParent() : null;
        }
        return null;
    }

    public Control getTestViewerControl() {
        return this.fViewerbook;
    }

    public synchronized void registerActiveSession(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
        this.registerAutoScrollTarget(null);
        this.registerViewersRefresh();
    }

    void handleDefaultSelected() {
        OpenTestAction action;
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TestElement testElement = (TestElement)selection.getFirstElement();
        if (testElement instanceof TestSuiteElement) {
            action = this.getOpenTestAction((TestSuiteElement)testElement);
        } else if (testElement instanceof TestCaseElement) {
            action = this.getOpenTestAction((TestCaseElement)testElement);
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
        if (action.isEnabled()) {
            action.run();
        }
    }

    private OpenTestAction getOpenTestAction(TestCaseElement testCase) {
        return new OpenTestAction(this.fTestRunnerPart, testCase, testCase.getParameterTypes());
    }

    private OpenTestAction getOpenTestAction(TestSuiteElement testSuite) {
        String testName = testSuite.getTestName();
        ITestElement[] children = testSuite.getChildren();
        if (testName.startsWith("[") && testName.endsWith("]") && children.length > 0 && children[0] instanceof TestCaseElement) {
            return new OpenTestAction(this.fTestRunnerPart, (TestCaseElement)children[0], null);
        }
        int index = testName.indexOf(40);
        if (index > 0) {
            if (children.length > 0 && children[0] instanceof TestCaseElement) {
                TestCaseElement testCase = (TestCaseElement)children[0];
                return new OpenTestAction(this.fTestRunnerPart, testCase, testCase.getParameterTypes());
            }
            return new OpenTestAction(this.fTestRunnerPart, testSuite.getSuiteTypeName(), testName.substring(0, index), testSuite.getParameterTypes(), true);
        }
        return new OpenTestAction(this.fTestRunnerPart, testName);
    }

    private void handleSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        TestElement testElement = null;
        if (selection.size() == 1) {
            testElement = (TestElement)selection.getFirstElement();
        }
        this.fTestRunnerPart.handleTestSelected(testElement);
    }

    public synchronized void setShowTime(boolean showTime) {
        try {
            this.fViewerbook.setRedraw(false);
            this.fTreeLabelProvider.setShowTime(showTime);
            this.fTableLabelProvider.setShowTime(showTime);
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    public synchronized void setShowFailuresOrIgnoredOnly(boolean failuresOnly, boolean ignoredOnly, int layoutMode) {
        try {
            boolean switchLayout;
            this.fViewerbook.setRedraw(false);
            IStructuredSelection selection = null;
            boolean bl = switchLayout = layoutMode != this.fLayoutMode;
            if (switchLayout) {
                selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
                if (layoutMode == 1) {
                    if (this.fTreeNeedsRefresh) {
                        this.clearUpdateAndExpansion();
                    }
                } else if (this.fTableNeedsRefresh) {
                    this.clearUpdateAndExpansion();
                }
                this.fLayoutMode = layoutMode;
                this.fViewerbook.showPage(this.getActiveViewer().getControl());
            }
            StructuredViewer viewer = this.getActiveViewer();
            if (failuresOnly || ignoredOnly) {
                if (this.getActiveViewerHasFilter()) {
                    viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
                    viewer.removeFilter((ViewerFilter)this.fIgnoredOnlyFilter);
                }
                this.setActiveViewerHasFilter(true);
                viewer.setInput(null);
                ViewerFilter filter = this.fFailuresOnlyFilter;
                if (ignoredOnly) {
                    filter = this.fIgnoredOnlyFilter;
                }
                viewer.addFilter(filter);
                this.setActiveViewerNeedsRefresh(true);
            } else if (this.getActiveViewerHasFilter()) {
                this.setActiveViewerNeedsRefresh(true);
                this.setActiveViewerHasFilter(false);
                viewer.setInput(null);
                viewer.removeFilter((ViewerFilter)this.fIgnoredOnlyFilter);
                viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
            }
            this.processChangesInUI();
            if (selection != null) {
                StructuredSelection flatSelection = new StructuredSelection(selection.toList());
                this.fSelectionProvider.setSelection((ISelection)flatSelection, true);
            }
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    private boolean getActiveViewerHasFilter() {
        if (this.fLayoutMode == 1) {
            return this.fTreeHasFilter;
        }
        return this.fTableHasFilter;
    }

    private void setActiveViewerHasFilter(boolean filter) {
        if (this.fLayoutMode == 1) {
            this.fTreeHasFilter = filter;
        } else {
            this.fTableHasFilter = filter;
        }
    }

    private StructuredViewer getActiveViewer() {
        if (this.fLayoutMode == 1) {
            return this.fTreeViewer;
        }
        return this.fTableViewer;
    }

    private boolean getActiveViewerNeedsRefresh() {
        if (this.fLayoutMode == 1) {
            return this.fTreeNeedsRefresh;
        }
        return this.fTableNeedsRefresh;
    }

    private void setActiveViewerNeedsRefresh(boolean needsRefresh) {
        if (this.fLayoutMode == 1) {
            this.fTreeNeedsRefresh = needsRefresh;
        } else {
            this.fTableNeedsRefresh = needsRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        if (this.fTestRunSession == null) {
            this.registerViewersRefresh();
            this.fTreeNeedsRefresh = false;
            this.fTableNeedsRefresh = false;
            this.fTreeViewer.setInput(null);
            this.fTableViewer.setInput(null);
            return;
        }
        TestRoot testRoot = this.fTestRunSession.getTestRoot();
        StructuredViewer viewer = this.getActiveViewer();
        if (this.getActiveViewerNeedsRefresh()) {
            this.clearUpdateAndExpansion();
            this.setActiveViewerNeedsRefresh(false);
            viewer.setInput((Object)testRoot);
        } else {
            Object element;
            int n;
            Object[] objectArray;
            Object[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray();
                this.fNeedUpdate.clear();
            }
            if (!this.fTreeNeedsRefresh && toUpdate.length > 0) {
                if (this.fTreeHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        this.updateElementInTree((TestElement)element);
                        ++n2;
                    }
                } else {
                    HashSet<Object> toUpdateWithParents = new HashSet<Object>();
                    toUpdateWithParents.addAll(Arrays.asList(toUpdate));
                    Object[] objectArray2 = toUpdate;
                    int n3 = toUpdate.length;
                    n = 0;
                    while (n < n3) {
                        Object element2 = objectArray2[n];
                        TestSuiteElement parent = ((TestElement)element2).getParent();
                        while (parent != null) {
                            toUpdateWithParents.add(parent);
                            parent = parent.getParent();
                        }
                        ++n;
                    }
                    this.fTreeViewer.update(toUpdateWithParents.toArray(), null);
                }
            }
            if (!this.fTableNeedsRefresh && toUpdate.length > 0) {
                if (this.fTableHasFilter) {
                    objectArray = toUpdate;
                    n = toUpdate.length;
                    int n4 = 0;
                    while (n4 < n) {
                        element = objectArray[n4];
                        this.updateElementInTable((TestElement)element);
                        ++n4;
                    }
                } else {
                    this.fTableViewer.update(toUpdate, null);
                }
            }
        }
        this.autoScrollInUI();
    }

    private void updateElementInTree(TestElement testElement) {
        if (this.isShown(testElement)) {
            this.updateShownElementInTree(testElement);
        } else {
            TestElement current = testElement;
            do {
                if (this.fTreeViewer.testFindItem((Object)current) == null) continue;
                this.fTreeViewer.remove((Object)current);
            } while (!((current = current.getParent()) instanceof TestRoot) && !this.isShown(current));
            while (current != null && !(current instanceof TestRoot)) {
                this.fTreeViewer.update((Object)current, null);
                current = current.getParent();
            }
        }
    }

    private void updateShownElementInTree(TestElement testElement) {
        if (testElement == null || testElement instanceof TestRoot) {
            return;
        }
        TestSuiteElement parent = testElement.getParent();
        this.updateShownElementInTree((TestElement)parent);
        if (this.fTreeViewer.testFindItem((Object)testElement) == null) {
            this.fTreeViewer.add((Object)parent, (Object)testElement);
        } else {
            this.fTreeViewer.update((Object)testElement, null);
        }
    }

    private void updateElementInTable(TestElement element) {
        if (this.isShown(element)) {
            if (this.fTableViewer.testFindItem((Object)element) == null) {
                TableItem item;
                TestElement previous = this.getNextFailure(element, false);
                int insertionIndex = -1;
                if (previous != null && (item = (TableItem)this.fTableViewer.testFindItem((Object)previous)) != null) {
                    insertionIndex = this.fTableViewer.getTable().indexOf(item);
                }
                this.fTableViewer.insert((Object)element, insertionIndex);
            } else {
                this.fTableViewer.update((Object)element, null);
            }
        } else {
            this.fTableViewer.remove((Object)element);
        }
    }

    private boolean isShown(TestElement current) {
        return this.fFailuresOnlyFilter.select(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        TestSuiteElement parent;
        if (!this.fTestRunnerPart.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        if (this.fLayoutMode == 0) {
            if (this.fAutoScrollTarget != null) {
                this.fTableViewer.reveal((Object)this.fAutoScrollTarget);
            }
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            for (TestSuiteElement suite : this.fAutoExpand) {
                this.fTreeViewer.setExpandedState((Object)suite, true);
            }
            this.clearAutoExpand();
        }
        TestCaseElement current = this.fAutoScrollTarget;
        this.fAutoScrollTarget = null;
        TestSuiteElement testSuiteElement = parent = current == null ? null : (TestSuiteElement)this.fTreeContentProvider.getParent(current);
        if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
            ListIterator<TestSuiteElement> iter = this.fAutoClose.listIterator(this.fAutoClose.size());
            while (iter.hasPrevious()) {
                TestSuiteElement previousAutoOpened = iter.previous();
                if (previousAutoOpened.equals(parent)) break;
                if (previousAutoOpened.getStatus() != TestElement.Status.OK) continue;
                iter.remove();
                this.fTreeViewer.collapseToLevel((Object)previousAutoOpened, -1);
            }
            while (parent != null && !this.fTestRunSession.getTestRoot().equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                this.fAutoClose.add(parent);
                parent = (TestSuiteElement)this.fTreeContentProvider.getParent(parent);
            }
        }
        if (current != null) {
            this.fTreeViewer.reveal((Object)current);
        }
    }

    public void selectFirstFailure() {
        TestElement firstFailure = this.getNextChildFailure((TestSuiteElement)this.fTestRunSession.getTestRoot(), true);
        if (firstFailure != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    public void selectFailure(boolean showNext) {
        IStructuredSelection selection = (IStructuredSelection)this.getActiveViewer().getSelection();
        TestElement selected = (TestElement)selection.getFirstElement();
        TestElement next = selected == null ? this.getNextChildFailure((TestSuiteElement)this.fTestRunSession.getTestRoot(), showNext) : this.getNextFailure(selected, showNext);
        if (next != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)next), true);
        }
    }

    private TestElement getNextFailure(TestElement selected, boolean showNext) {
        TestElement nextChild;
        if (selected instanceof TestSuiteElement && (nextChild = this.getNextChildFailure((TestSuiteElement)selected, showNext)) != null) {
            return nextChild;
        }
        return this.getNextFailureSibling(selected, showNext);
    }

    private TestElement getNextFailureSibling(TestElement current, boolean showNext) {
        int nextIndex;
        TestSuiteElement parent = current.getParent();
        if (parent == null) {
            return null;
        }
        List<ITestElement> siblings = Arrays.asList(parent.getChildren());
        if (!showNext) {
            siblings = new ReverseList<ITestElement>(siblings);
        }
        int i = nextIndex = siblings.indexOf(current) + 1;
        while (i < siblings.size()) {
            TestElement sibling = (TestElement)siblings.get(i);
            if (sibling.getStatus().isErrorOrFailure()) {
                if (sibling instanceof TestCaseElement) {
                    return sibling;
                }
                TestSuiteElement testSuiteElement = (TestSuiteElement)sibling;
                if (testSuiteElement.getChildren().length == 0) {
                    return testSuiteElement;
                }
                return this.getNextChildFailure(testSuiteElement, showNext);
            }
            ++i;
        }
        return this.getNextFailureSibling((TestElement)parent, showNext);
    }

    private TestElement getNextChildFailure(TestSuiteElement root, boolean showNext) {
        List<ITestElement> children = Arrays.asList(root.getChildren());
        if (!showNext) {
            children = new ReverseList<ITestElement>(children);
        }
        int i = 0;
        while (i < children.size()) {
            TestElement child = (TestElement)children.get(i);
            if (child.getStatus().isErrorOrFailure()) {
                if (child instanceof TestCaseElement) {
                    return child;
                }
                TestSuiteElement testSuiteElement = (TestSuiteElement)child;
                if (testSuiteElement.getChildren().length == 0) {
                    return testSuiteElement;
                }
                return this.getNextChildFailure(testSuiteElement, showNext);
            }
            ++i;
        }
        return null;
    }

    public synchronized void registerViewersRefresh() {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
        this.clearUpdateAndExpansion();
    }

    private void clearUpdateAndExpansion() {
        this.fNeedUpdate = new LinkedHashSet<TestElement>();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet();
    }

    public synchronized void registerTestAdded(TestElement testElement) {
        this.fTreeNeedsRefresh = true;
        this.fTableNeedsRefresh = true;
    }

    public synchronized void registerViewerUpdate(TestElement testElement) {
        this.fNeedUpdate.add(testElement);
    }

    private synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    public void registerAutoScrollTarget(TestCaseElement testCaseElement) {
        this.fAutoScrollTarget = testCaseElement;
    }

    public synchronized void registerFailedForAutoScroll(TestElement testElement) {
        TestSuiteElement parent = (TestSuiteElement)this.fTreeContentProvider.getParent(testElement);
        if (parent != null) {
            this.fAutoExpand.add(parent);
        }
    }

    public void expandFirstLevel() {
        this.fTreeViewer.expandToLevel(2);
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(JUnitMessages.ExpandAllAction_text);
            this.setToolTipText(JUnitMessages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.expandAll();
        }
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((TestElement)element);
        }

        public boolean select(TestElement testElement) {
            TestElement.Status status = testElement.getStatus();
            if (status.isErrorOrFailure()) {
                return true;
            }
            return !TestViewer.this.fTestRunSession.isRunning() && status == TestElement.Status.RUNNING;
        }
    }

    private final class IgnoredOnlyFilter
    extends ViewerFilter {
        private IgnoredOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((TestElement)element);
        }

        public boolean select(TestElement testElement) {
            if (this.hasIgnoredInTestResult(testElement)) {
                return true;
            }
            return !TestViewer.this.fTestRunSession.isRunning() && testElement.getStatus() == TestElement.Status.RUNNING;
        }

        private boolean hasIgnoredInTestResult(TestElement testElement) {
            if (testElement instanceof TestSuiteElement) {
                ITestElement[] children;
                ITestElement[] iTestElementArray = children = ((TestSuiteElement)testElement).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ITestElement child = iTestElementArray[n2];
                    boolean hasIgnoredTestResult = this.hasIgnoredInTestResult((TestElement)child);
                    if (hasIgnoredTestResult) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return testElement.getTestResult(false) == ITestElement.Result.IGNORED;
        }
    }

    private static class ReverseList<E>
    extends AbstractList<E> {
        private final List<E> fList;

        public ReverseList(List<E> list) {
            this.fList = list;
        }

        @Override
        public E get(int index) {
            return this.fList.get(this.fList.size() - index - 1);
        }

        @Override
        public int size() {
            return this.fList.size();
        }
    }

    private final class TestOpenListener
    extends SelectionAdapter {
        private TestOpenListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TestViewer.this.handleDefaultSelected();
        }
    }

    private final class TestSelectionListener
    implements ISelectionChangedListener {
        private TestSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TestViewer.this.handleSelected();
        }
    }
}

