/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointOrganizerVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointOrganizerVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMInput;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMModelProxyStrategy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointsChangedEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.DataCache;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.breakpoints.provisional.OtherBreakpointCategory;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultBreakpointsViewInput;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegate;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbenchWindow;

public class BreakpointVMProvider
extends AbstractVMProvider {
    private IPropertyChangeListener fPresentationContextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            BreakpointVMProvider.this.handleEventInExecThread(event);
        }
    };
    private IBreakpointsListener fBreakpointsListener = new IBreakpointsListener(){

        public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
            BreakpointVMProvider.this.handleEventInExecThread(new BreakpointsChangedEvent(BreakpointsChangedEvent.Type.REMOVED, breakpoints));
        }

        public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
            BreakpointVMProvider.this.handleEventInExecThread(new BreakpointsChangedEvent(BreakpointsChangedEvent.Type.CHANGED, breakpoints));
        }

        public void breakpointsAdded(IBreakpoint[] breakpoints) {
            BreakpointVMProvider.this.handleEventInExecThread(new BreakpointsChangedEvent(BreakpointsChangedEvent.Type.ADDED, breakpoints));
        }
    };
    private IDebugContextListener fDebugContextListener = new IDebugContextListener(){

        public void debugContextChanged(DebugContextEvent event) {
            BreakpointVMProvider.this.handleEventInExecThread(event);
        }
    };
    private final Map<TreePath, ContainerBreakpointsCache> fContainerBreakpointsCacheMap = new HashMap<TreePath, ContainerBreakpointsCache>();
    private DataCache<IBreakpoint[]> fFilteredBreakpointsCache = new DataCache<IBreakpoint[]>(this.getExecutor()){

        @Override
        protected void retrieve(DataRequestMonitor<IBreakpoint[]> rm) {
            BreakpointVMProvider.this.calcFileteredBreakpoints(rm);
        }
    };
    private static final int MODEL_DELTA_CHANGE_FLAGS = 3099;

    public BreakpointVMProvider(AbstractVMAdapter adapter, IPresentationContext context) {
        super(adapter, context);
        this.setRootNode(new RootDMVMNode(this));
        this.configureLayout();
        context.addPropertyChangeListener(this.fPresentationContextListener);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(this.fBreakpointsListener);
        IWorkbenchWindow window = context.getWindow();
        if (window != null) {
            DebugUITools.getDebugContextManager().getContextService(window).addDebugContextListener(this.fDebugContextListener);
        }
    }

    @Override
    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        return new BreakpointVMModelProxyStrategy(this, rootElement);
    }

    protected IVMNode createBreakpointVMNode() {
        return new BreakpointVMNode(this);
    }

    protected void configureLayout() {
        IBreakpointOrganizer[] organizers = (IBreakpointOrganizer[])this.getPresentationContext().getProperty("BreakpointOrganizers");
        IVMNode parentNode = this.getRootVMNode();
        if (organizers != null) {
            IBreakpointOrganizer[] iBreakpointOrganizerArray = organizers;
            int n = organizers.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpointOrganizer organizer = iBreakpointOrganizerArray[n2];
                BreakpointOrganizerVMNode organizerNode = new BreakpointOrganizerVMNode(this, organizer);
                this.addChildNodes(parentNode, new IVMNode[]{organizerNode});
                parentNode = organizerNode;
                ++n2;
            }
        }
        IVMNode bpsNode = this.createBreakpointVMNode();
        this.addChildNodes(parentNode, new IVMNode[]{bpsNode});
    }

    @Override
    public void dispose() {
        this.getPresentationContext().removePropertyChangeListener(this.fPresentationContextListener);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener(this.fBreakpointsListener);
        IWorkbenchWindow window = this.getPresentationContext().getWindow();
        if (window != null) {
            DebugUITools.getDebugContextManager().getContextService(window).removeDebugContextListener(this.fDebugContextListener);
        }
        super.dispose();
    }

    @Override
    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return null;
    }

    @Override
    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return null;
    }

    @Override
    public void update(IViewerInputUpdate update) {
        IDMContext activeDMContext = null;
        if (update.getElement() instanceof IDMVMContext) {
            activeDMContext = ((IDMVMContext)update.getElement()).getDMContext();
            activeDMContext = DMContexts.getAncestorOfType((IDMContext)activeDMContext, IBreakpoints.IBreakpointsTargetDMContext.class);
        }
        if (activeDMContext != null) {
            update.setInputElement((Object)new BreakpointVMInput(this.getRootVMNode(), activeDMContext));
        } else {
            update.setInputElement((Object)new DefaultBreakpointsViewInput(update.getPresentationContext()));
        }
        update.done();
    }

    public void getNestingCategoryBreakpoints(TreePath path, DataRequestMonitor<IBreakpoint[]> rm) {
        AbstractVMContext nestingOrganizerVmc = null;
        while (path.getSegmentCount() > 0) {
            if (path.getLastSegment() instanceof BreakpointOrganizerVMContext) {
                nestingOrganizerVmc = (BreakpointOrganizerVMContext)path.getLastSegment();
                break;
            }
            path = path.getParentPath();
        }
        if (nestingOrganizerVmc == null) {
            this.getFileteredBreakpoints(rm);
        } else {
            AbstractVMContext _nestingOrganizerVmc = nestingOrganizerVmc;
            this.getBreakpointOrganizerVMCs((BreakpointOrganizerVMNode)_nestingOrganizerVmc.getVMNode(), path.getParentPath(), new DataRequestMonitor<List<BreakpointOrganizerVMContext>>(this.getExecutor(), rm, (BreakpointOrganizerVMContext)_nestingOrganizerVmc, rm){
                private final /* synthetic */ BreakpointOrganizerVMContext val$_nestingOrganizerVmc;
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$_nestingOrganizerVmc = breakpointOrganizerVMContext;
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    int newVmcIdx = ((List)this.getData()).indexOf(this.val$_nestingOrganizerVmc);
                    if (newVmcIdx >= 0) {
                        this.val$rm.setData((Object)((BreakpointOrganizerVMContext)((List)this.getData()).get(newVmcIdx)).getBreakpoints());
                    } else {
                        this.val$rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Breakpoint category not found", null));
                    }
                    this.val$rm.done();
                }
            });
        }
    }

    public void getBreakpointOrganizerVMCs(BreakpointOrganizerVMNode organizerVMNode, TreePath path, DataRequestMonitor<List<BreakpointOrganizerVMContext>> rm) {
        ContainerBreakpointsCache cache = this.fContainerBreakpointsCacheMap.get(path);
        if (cache == null) {
            cache = new ContainerBreakpointsCache(organizerVMNode, path);
            this.fContainerBreakpointsCacheMap.put(path, cache);
        }
        cache.request(rm);
    }

    protected BreakpointOrganizerVMContext createBreakpointOrganizerVMContext(BreakpointOrganizerVMNode node, IAdaptable category, IBreakpoint[] breakpoints) {
        return new BreakpointOrganizerVMContext(node, category, breakpoints);
    }

    public void getFileteredBreakpoints(DataRequestMonitor<IBreakpoint[]> rm) {
        this.fFilteredBreakpointsCache.request(rm);
    }

    protected void calcFileteredBreakpoints(DataRequestMonitor<IBreakpoint[]> rm) {
        rm.setData((Object)DebugPlugin.getDefault().getBreakpointManager().getBreakpoints());
        rm.done();
    }

    public void getBreakpointsForDebugContext(ISelection debugContext, DataRequestMonitor<IBreakpoint[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "Not supported", null));
        rm.done();
    }

    public void handleEventInExecThread(final Object event) {
        this.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                BreakpointVMProvider.this.handleEvent(event);
            }
        });
    }

    @Override
    public void handleEvent(Object event, RequestMonitor rm) {
        PropertyChangeEvent propertyEvent;
        if (BreakpointVMProvider.isPresentationContextEvent(event) && "BreakpointOrganizers".equals((propertyEvent = (PropertyChangeEvent)event).getProperty())) {
            this.clearNodes(false);
            this.configureLayout();
        }
        super.handleEvent(event, rm);
    }

    public static boolean isPresentationContextEvent(Object event) {
        return event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getSource() instanceof IPresentationContext;
    }

    public static boolean isBreakpointOrganizerEvent(Object event) {
        return event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getSource() instanceof IBreakpointOrganizerDelegate;
    }

    @Override
    protected void handleEvent(IVMModelProxy proxyStrategy, Object event, RequestMonitor rm) {
        int deltaFlags = proxyStrategy.getEventDeltaFlags(event);
        if ((deltaFlags & 0xC1B) != 0) {
            this.flushCaches();
        }
        super.handleEvent(proxyStrategy, event, rm);
    }

    private void flushCaches() {
        this.fFilteredBreakpointsCache.reset();
        for (DataCache dataCache : this.fContainerBreakpointsCacheMap.values()) {
            dataCache.reset();
        }
        this.fContainerBreakpointsCacheMap.clear();
    }

    private class ContainerBreakpointsCache
    extends DataCache<List<BreakpointOrganizerVMContext>> {
        private BreakpointOrganizerVMNode fOrganizerVMNode;
        private TreePath fParentPath;

        public ContainerBreakpointsCache(BreakpointOrganizerVMNode organizerVMNode, TreePath parentPath) {
            super(BreakpointVMProvider.this.getExecutor());
            this.fOrganizerVMNode = organizerVMNode;
            this.fParentPath = parentPath;
        }

        @Override
        protected void retrieve(final DataRequestMonitor<List<BreakpointOrganizerVMContext>> rm) {
            BreakpointVMProvider.this.getNestingCategoryBreakpoints(this.fParentPath, new DataRequestMonitor<IBreakpoint[]>(BreakpointVMProvider.this.getExecutor(), rm){

                protected void handleSuccess() {
                    IAdaptable[] independentCategories;
                    IAdaptable[] bpCategories;
                    HashMap<IAdaptable, List> bpsLists = new HashMap<IAdaptable, List>();
                    IBreakpoint[] iBreakpointArray = (IBreakpoint[])this.getData();
                    int n = iBreakpointArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint bp = iBreakpointArray[n2];
                        bpCategories = ContainerBreakpointsCache.this.fOrganizerVMNode.getOrganizer().getCategories(bp);
                        if (bpCategories == null || bpCategories.length == 0) {
                            bpCategories = OtherBreakpointCategory.getCategories((IBreakpointOrganizer)ContainerBreakpointsCache.this.fOrganizerVMNode.getOrganizer());
                        }
                        IAdaptable[] iAdaptableArray = bpCategories;
                        int n3 = bpCategories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IAdaptable category = iAdaptableArray[n4];
                            ArrayList<IBreakpoint> categoryBPs = (ArrayList<IBreakpoint>)bpsLists.get(category);
                            if (categoryBPs == null) {
                                categoryBPs = new ArrayList<IBreakpoint>();
                                bpsLists.put(category, categoryBPs);
                            }
                            categoryBPs.add(bp);
                            ++n4;
                        }
                        ++n2;
                    }
                    if (ContainerBreakpointsCache.this.fParentPath.getSegmentCount() == 0 && (independentCategories = ContainerBreakpointsCache.this.fOrganizerVMNode.getOrganizer().getCategories()) != null) {
                        bpCategories = independentCategories;
                        int n5 = independentCategories.length;
                        n = 0;
                        while (n < n5) {
                            IAdaptable category = bpCategories[n];
                            if (!bpsLists.containsKey(category)) {
                                bpsLists.put(category, Collections.EMPTY_LIST);
                            }
                            ++n;
                        }
                    }
                    ArrayList<BreakpointOrganizerVMContext> vmcs = new ArrayList<BreakpointOrganizerVMContext>(bpsLists.size());
                    for (Map.Entry entry : bpsLists.entrySet()) {
                        List bpsList = (List)entry.getValue();
                        IBreakpoint[] bpsArray = bpsList.toArray(new IBreakpoint[bpsList.size()]);
                        vmcs.add(BreakpointVMProvider.this.createBreakpointOrganizerVMContext(ContainerBreakpointsCache.this.fOrganizerVMNode, (IAdaptable)entry.getKey(), bpsArray));
                    }
                    Comparator comparator = (Comparator)BreakpointVMProvider.this.getPresentationContext().getProperty("ElementComparator");
                    if (comparator != null) {
                        Collections.sort(vmcs, comparator);
                    }
                    rm.setData(vmcs);
                    rm.done();
                }
            });
        }
    }
}

