/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.registry.IRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Registry<K, V>
extends Container<Map.Entry<K, V>>
implements IRegistry<K, V> {
    private boolean autoCommit;
    private Transaction transaction;

    protected Registry(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    protected Registry() {
        this(true);
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getMap().values();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        V result = this.register(key, value);
        this.autoCommit();
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        if (!t.isEmpty()) {
            for (Map.Entry<K, V> e : t.entrySet()) {
                this.register(e.getKey(), e.getValue());
            }
            this.autoCommit();
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V result = this.deregister(key);
        this.autoCommit();
        return result;
    }

    @Override
    public synchronized void clear() {
        if (!this.isEmpty()) {
            Object[] objectArray = this.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                this.deregister(key);
                ++n2;
            }
            this.autoCommit();
        }
    }

    public Map.Entry<K, V>[] getElements() {
        return this.entrySet().toArray(new Map.Entry[this.size()]);
    }

    @Override
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public synchronized void commit(boolean notifications) {
        if (this.transaction != null) {
            if (!this.transaction.isOwned()) {
                OM.LOG.warn("Committing thread is not owner of transaction: " + Thread.currentThread());
            }
            this.transaction.commit(notifications);
            this.transaction = null;
            this.notifyAll();
        }
    }

    @Override
    public void commit() {
        this.commit(true);
    }

    @Override
    public String toString() {
        return this.getMap().toString();
    }

    protected V register(K key, V value) {
        Transaction transaction = this.getTransaction();
        V oldValue = this.getMap().put(key, value);
        if (oldValue != null) {
            transaction.rememberDeregistered(key, oldValue);
        }
        transaction.rememberRegistered(key, value);
        return oldValue;
    }

    protected V deregister(Object key) {
        V value = this.getMap().remove(key);
        if (value != null) {
            this.getTransaction().rememberDeregistered(key, value);
        }
        return value;
    }

    protected Transaction getTransaction() {
        while (true) {
            if (this.transaction == null) {
                this.transaction = new Transaction();
                return this.transaction;
            }
            if (this.transaction.isOwned()) {
                this.transaction.increaseNesting();
                return this.transaction;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap(ex);
            }
        }
    }

    protected void autoCommit() {
        if (this.autoCommit) {
            this.commit();
        }
    }

    protected abstract Map<K, V> getMap();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Element<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private Element(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Transaction {
        private int nesting = 1;
        private ContainerEvent<Map.Entry<K, V>> event;
        private Thread owner = Thread.currentThread();

        public Transaction() {
            this.initEvent();
        }

        private void initEvent() {
            this.event = Registry.this.newContainerEvent();
        }

        public boolean isOwned() {
            return this.owner == Thread.currentThread();
        }

        public void increaseNesting() {
            ++this.nesting;
        }

        public void commit(boolean notifications) {
            if (--this.nesting == 0) {
                if (notifications && !this.event.isEmpty()) {
                    Registry.this.fireEvent(this.event);
                }
                this.initEvent();
            }
        }

        public void rememberRegistered(K key, V value) {
            this.event.addDelta(new Element(key, value), IContainerDelta.Kind.ADDED);
        }

        public void rememberDeregistered(K key, V value) {
            this.event.addDelta(new Element(key, value), IContainerDelta.Kind.REMOVED);
        }
    }
}

