/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.MessageDigest;

public class DigestWriter
extends FilterWriter {
    private boolean on = true;
    protected MessageDigest digest;

    public DigestWriter(Writer writer, MessageDigest digest) {
        super(writer);
        this.setMessageDigest(digest);
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public void write(int c) throws IOException {
        if (this.on) {
            this.updateDigest(c);
        }
        this.out.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.on) {
            int end = off + len;
            int i = off;
            while (i < end) {
                this.updateDigest(cbuf[i]);
                ++i;
            }
        }
        this.out.write(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.on) {
            int end = off + len;
            int i = off;
            while (i < end) {
                this.updateDigest(str.charAt(i));
                ++i;
            }
        }
        this.out.write(str, off, len);
    }

    private void updateDigest(int c) {
        this.digest.update((byte)(c >>> 8 & 0xFF));
        this.digest.update((byte)(c >>> 0 & 0xFF));
    }

    public void on(boolean on) {
        this.on = on;
    }

    public String toString() {
        return "[Digest Writer] " + this.digest.toString();
    }
}

