/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;

public class IdeJavaSourceOutputStream
extends ByteArrayOutputStream {
    private final IdeProcessingEnvImpl _env;
    private final CharSequence _name;
    private final Collection<IFile> _parentFiles;
    private boolean _closed = false;

    public IdeJavaSourceOutputStream(IdeProcessingEnvImpl env, CharSequence name, Collection<IFile> parentFiles) {
        this._env = env;
        this._name = name;
        this._parentFiles = parentFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IdeJavaSourceOutputStream ideJavaSourceOutputStream = this;
        synchronized (ideJavaSourceOutputStream) {
            if (this._closed) {
                return;
            }
            this._closed = true;
        }
        try {
            GeneratedFileManager gfm = this._env.getAptProject().getGeneratedFileManager();
            Phase phase = this._env.getPhase();
            FileGenerationResult result = null;
            if (phase != Phase.RECONCILE && phase == Phase.BUILD) {
                String charset = this._env.getJavaProject().getProject().getDefaultCharset();
                result = gfm.generateFileDuringBuild(this._parentFiles, this._name.toString(), charset == null ? this.toString() : this.toString(charset), this._env.currentProcessorSupportsRTTG(), null);
            }
            if (result != null) {
                this._env.addNewUnit(result);
            }
        }
        catch (CoreException ce) {
            Apt6Plugin.log(ce, "Unable to generate type when IdeJavaSourceOutputStream was closed");
        }
    }
}

