/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef.zest.fx.ZestProperties;

public class EdgePart
extends AbstractContentPart<Connection>
implements IBendableContentPart<Connection> {
    public static final String CSS_CLASS = "edge";
    public static final String CSS_CLASS_CURVE = "curve";
    public static final String CSS_CLASS_DECORATION = "decoration";
    private MapChangeListener<String, Object> edgeAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            if ("edge-router".equals(change.getKey())) {
                for (Map.Entry anchoragesByRole : EdgePart.this.getAnchoragesUnmodifiable().entries()) {
                    EdgePart.this.doDetachFromAnchorageVisual((IVisualPart<? extends Node>)((IVisualPart)anchoragesByRole.getKey()), (String)anchoragesByRole.getValue());
                    EdgePart.this.doAttachToAnchorageVisual((IVisualPart<? extends Node>)((IVisualPart)anchoragesByRole.getKey()), (String)anchoragesByRole.getValue());
                }
            }
            EdgePart.this.refreshVisual();
        }
    };

    protected void doActivate() {
        super.doActivate();
        this.getContent().attributesProperty().addListener(this.edgeAttributesObserver);
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        if (!((Connection)this.getVisual()).getChildren().contains((Object)child.getVisual())) {
            ((Connection)this.getVisual()).getChildren().add((Object)child.getVisual());
        }
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        IAnchor anchor = ((IAnchorProvider)anchorage.getAdapter(IAnchorProvider.class)).get((IVisualPart)this, role);
        if ("source".equals(role)) {
            ((Connection)this.getVisual()).setStartAnchor(anchor);
        } else if ("target".equals(role)) {
            ((Connection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalArgumentException("Cannot attach to anchor with role <" + role + ">.");
        }
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        if ("source".equals(role)) {
            this.getContent().setSource((org.eclipse.gef.graph.Node)contentAnchorage);
        } else if ("target".equals(role)) {
            this.getContent().setTarget((org.eclipse.gef.graph.Node)contentAnchorage);
        } else {
            throw new IllegalArgumentException("Cannot attach to content anchorage with role <" + role + ">.");
        }
    }

    protected Connection doCreateVisual() {
        Connection visual = new Connection();
        visual.getStyleClass().add((Object)CSS_CLASS);
        visual.getCurve().getStyleClass().add((Object)CSS_CLASS_CURVE);
        if (visual.getStartDecoration() != null && !visual.getStartDecoration().getStyleClass().contains((Object)CSS_CLASS_DECORATION)) {
            visual.getStartDecoration().getStyleClass().add((Object)CSS_CLASS_DECORATION);
        }
        if (visual.getEndDecoration() != null && !visual.getEndDecoration().getStyleClass().contains((Object)CSS_CLASS_DECORATION)) {
            visual.getEndDecoration().getStyleClass().add((Object)CSS_CLASS_DECORATION);
        }
        return visual;
    }

    protected void doDeactivate() {
        this.getContent().attributesProperty().removeListener(this.edgeAttributesObserver);
        super.doDeactivate();
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        Connection connection = (Connection)this.getVisual();
        if (role.equals("source")) {
            Point startPoint = connection.getStartPoint();
            connection.setStartPoint(startPoint == null ? new Point() : startPoint);
        } else if (role.equals("target")) {
            Point endPoint = connection.getEndPoint();
            connection.setEndPoint(endPoint == null ? new Point() : endPoint);
        } else {
            throw new IllegalArgumentException("Cannot detach from anchor with role <" + role + ">.");
        }
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        if ("source".equals(role)) {
            this.getContent().setSource(null);
        } else if ("target".equals(role)) {
            this.getContent().setTarget(null);
        } else {
            throw new IllegalArgumentException("Cannot detach from content anchorage with role <" + role + ">.");
        }
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        org.eclipse.gef.graph.Node target;
        HashMultimap anchorages = HashMultimap.create();
        org.eclipse.gef.graph.Node source = this.getContent().getSource();
        if (source != null) {
            anchorages.put((Object)source, (Object)"source");
        }
        if ((target = this.getContent().getTarget()) != null) {
            anchorages.put((Object)target, (Object)"target");
        }
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    protected void doRefreshVisual(Connection visual) {
        IConnectionInterpolator interpolator;
        IConnectionRouter router;
        String targetDecorationCssStyle;
        Node targetDecoration;
        String sourceDecorationCssStyle;
        Node sourceDecoration;
        Edge edge = this.getContent();
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        this.refreshCurve();
        if (attrs.containsKey("element-css-class")) {
            String cssClass = ZestProperties.getCssClass(edge);
            if (!visual.getStyleClass().contains((Object)cssClass)) {
                visual.getStyleClass().add((Object)cssClass);
            }
        }
        if (attrs.containsKey("element-css-id")) {
            String cssId = ZestProperties.getCssId(edge);
            visual.setId(cssId);
        }
        String curveCssStyle = ZestProperties.getCurveCssStyle(edge);
        if (attrs.containsKey("edge-curve-css-style")) {
            visual.getCurve().setStyle(curveCssStyle);
        }
        if ((sourceDecoration = ZestProperties.getSourceDecoration(edge)) != null) {
            visual.setStartDecoration(sourceDecoration);
            if (!sourceDecoration.getStyleClass().contains((Object)CSS_CLASS_DECORATION)) {
                sourceDecoration.getStyleClass().add((Object)CSS_CLASS_DECORATION);
            }
        }
        if ((sourceDecorationCssStyle = ZestProperties.getSourceDecorationCssStyle(edge)) != null && visual.getStartDecoration() != null) {
            visual.getStartDecoration().setStyle(sourceDecorationCssStyle);
        }
        if ((targetDecoration = ZestProperties.getTargetDecoration(edge)) != null) {
            visual.setEndDecoration(targetDecoration);
            if (!targetDecoration.getStyleClass().contains((Object)CSS_CLASS_DECORATION)) {
                targetDecoration.getStyleClass().add((Object)CSS_CLASS_DECORATION);
            }
        }
        if ((targetDecorationCssStyle = ZestProperties.getTargetDecorationCssStyle(edge)) != null && visual.getEndDecoration() != null) {
            visual.getEndDecoration().setStyle(targetDecorationCssStyle);
        }
        if ((router = ZestProperties.getRouter(edge)) != null) {
            visual.setRouter(router);
        }
        if ((interpolator = ZestProperties.getInterpolator(edge)) != null) {
            visual.setInterpolator(interpolator);
        }
        Point startPoint = ZestProperties.getStartPoint(edge);
        if (!this.getContentAnchoragesUnmodifiable().containsValue((Object)"source")) {
            if (startPoint != null) {
                visual.setStartPoint(startPoint);
            }
        } else {
            visual.setStartPointHint(startPoint);
        }
        Point endPoint = ZestProperties.getEndPoint(edge);
        if (!this.getContentAnchoragesUnmodifiable().containsValue((Object)"target")) {
            if (endPoint != null) {
                visual.setEndPoint(endPoint);
            }
        } else {
            visual.setEndPointHint(endPoint);
        }
        ArrayList<Point> controlPoints = new ArrayList<Point>(ZestProperties.getControlPoints(edge));
        if (!visual.getControlPoints().equals(controlPoints)) {
            visual.setControlPoints(controlPoints);
        }
    }

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        ((Connection)this.getVisual()).getChildren().remove((Object)child.getVisual());
    }

    public Edge getContent() {
        return (Edge)super.getContent();
    }

    public List<IBendableContentPart.BendPoint> getContentBendPoints() {
        ArrayList<IBendableContentPart.BendPoint> bendPoints = new ArrayList<IBendableContentPart.BendPoint>();
        Edge edge = this.getContent();
        Point startPoint = ZestProperties.getStartPoint(edge);
        Point endPoint = ZestProperties.getEndPoint(edge);
        List<Point> controlPoints = ZestProperties.getControlPoints(edge);
        if (startPoint == null || endPoint == null) {
            return bendPoints;
        }
        if (edge.getSource() == null) {
            bendPoints.add(new IBendableContentPart.BendPoint(startPoint));
        } else {
            bendPoints.add(new IBendableContentPart.BendPoint((Object)edge.getSource(), startPoint));
        }
        for (Point cp : controlPoints) {
            bendPoints.add(new IBendableContentPart.BendPoint(cp));
        }
        if (edge.getTarget() == null) {
            bendPoints.add(new IBendableContentPart.BendPoint(endPoint));
        } else {
            bendPoints.add(new IBendableContentPart.BendPoint((Object)edge.getTarget(), endPoint));
        }
        return bendPoints;
    }

    public Node getCurve() {
        return ((Connection)this.getVisual()).getCurve();
    }

    private void refreshCurve() {
        Node curve = ZestProperties.getCurve(this.getContent());
        if (((Connection)this.getVisual()).getCurve() != curve && curve != null) {
            ((Connection)this.getVisual()).setCurve(curve);
            if (!curve.getStyleClass().contains((Object)CSS_CLASS_CURVE)) {
                curve.getStyleClass().add((Object)CSS_CLASS_CURVE);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentBendPoints(List<IBendableContentPart.BendPoint> bendPoints) {
        boolean wasRefreshVisual = this.isRefreshVisual();
        this.setRefreshVisual(false);
        ArrayList<Point> positions = new ArrayList<Point>();
        boolean attachedSource = false;
        boolean attachedTarget = false;
        int i = 0;
        while (i < bendPoints.size()) {
            IBendableContentPart.BendPoint bp = bendPoints.get(i);
            if (i == 0) {
                org.eclipse.gef.graph.Node newSource = bp.isAttached() ? (org.eclipse.gef.graph.Node)bp.getContentAnchorage() : null;
                org.eclipse.gef.graph.Node oldSource = this.getContent().getSource();
                if (oldSource != newSource) {
                    if (oldSource != null) {
                        this.detachFromContentAnchorage(oldSource, "source");
                    }
                    if (newSource != null) {
                        this.attachToContentAnchorage(newSource, "source");
                        attachedSource = true;
                    }
                } else if (oldSource != null) {
                    attachedSource = true;
                }
                if (attachedSource) {
                    ((Connection)this.getVisual()).setStartPointHint(bp.getPosition());
                }
            }
            if (i == bendPoints.size() - 1) {
                org.eclipse.gef.graph.Node newTarget = bp.isAttached() ? (org.eclipse.gef.graph.Node)bp.getContentAnchorage() : null;
                org.eclipse.gef.graph.Node oldTarget = this.getContent().getTarget();
                if (oldTarget != newTarget) {
                    if (oldTarget != null) {
                        this.detachFromContentAnchorage(oldTarget, "target");
                    }
                    if (newTarget != null) {
                        this.attachToContentAnchorage(newTarget, "target");
                        attachedTarget = true;
                    }
                } else if (oldTarget != null) {
                    attachedTarget = true;
                }
                if (attachedTarget) {
                    ((Connection)this.getVisual()).setEndPointHint(bp.getPosition());
                }
            }
            if (!bp.isAttached()) {
                positions.add(bp.getPosition());
            }
            ++i;
        }
        if (!attachedSource) {
            if (positions.size() <= 0) throw new IllegalStateException("No start point provided.");
            ZestProperties.setStartPoint(this.getContent(), (Point)positions.remove(0));
        } else {
            ZestProperties.setStartPoint(this.getContent(), ((Connection)this.getVisual()).getStartPointHint());
        }
        if (!attachedTarget) {
            if (positions.size() <= 0) throw new IllegalStateException("No end point provided.");
            ZestProperties.setEndPoint(this.getContent(), (Point)positions.remove(positions.size() - 1));
        } else {
            ZestProperties.setEndPoint(this.getContent(), ((Connection)this.getVisual()).getEndPointHint());
        }
        ZestProperties.setControlPoints(this.getContent(), positions);
        this.setRefreshVisual(wasRefreshVisual);
        this.refreshVisual();
    }
}

