/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.indexing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.parser.TclVisitor;

public class SpawnpointCollector
extends TclVisitor {
    private static final String PROC_COMMAND = "proc";
    private final IBuildContext buildContext;
    private final Set<String> spawnCommands;
    private ISourceLineTracker lineTracker;
    public final Map<Integer, SpawnpointInfo> spawnpoints = new HashMap<Integer, SpawnpointInfo>();

    public SpawnpointCollector(IBuildContext buildContext, Set<String> spawnCommands) {
        this.buildContext = buildContext;
        this.spawnCommands = spawnCommands;
    }

    public void setLineTracker(ISourceLineTracker lineTracker) {
        this.lineTracker = lineTracker;
    }

    private StringArgument getStringArgument(TclCommand command, int index) {
        TclArgument argument;
        if (index < command.getArguments().size() && (argument = (TclArgument)command.getArguments().get(index)) instanceof StringArgument) {
            return (StringArgument)argument;
        }
        return null;
    }

    public boolean visit(TclCommand command) {
        if (PROC_COMMAND.equals(command.getQualifiedName()) && command.getArguments().size() == 3) {
            StringArgument procName = this.getStringArgument(command, 0);
            if (procName != null && this.spawnCommands.contains(procName.getValue())) {
                return false;
            }
        } else if (this.spawnCommands.contains(command.getQualifiedName())) {
            if (this.lineTracker == null) {
                this.lineTracker = this.buildContext.getLineTracker();
            }
            int lineNumber = this.lineTracker.getLineNumberOfOffset(command.getStart());
            this.addSpawnpoint(lineNumber, command.getQualifiedName(), command.getStart(), command.getEnd());
        }
        return true;
    }

    private void addSpawnpoint(int lineNumber, String commandName, int start, int end) {
        Integer lineObj = lineNumber;
        SpawnpointInfo info = this.spawnpoints.get(lineObj);
        if (info == null) {
            info = new SpawnpointInfo();
            info.commands = Collections.singleton(commandName);
            info.charStart = start;
            info.charEnd = end;
            this.spawnpoints.put(lineObj, info);
        } else {
            if (!info.commands.contains(commandName)) {
                HashSet<String> commandNames = new HashSet<String>();
                commandNames.addAll(info.commands);
                commandNames.add(commandName);
                info.commands = commandNames;
            }
            if (start < info.charStart) {
                info.charStart = start;
            }
            if (end > info.charEnd) {
                info.charEnd = end;
            }
        }
    }

    public static class SpawnpointInfo {
        public Set<String> commands;
        public int charStart;
        public int charEnd;
    }
}

