/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.execution;

import java.beans.Beans;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class ExecutionUtils {
    private ExecutionUtils() {
    }

    public static void sleep(int millis) {
        long end = System.currentTimeMillis() + (long)millis;
        do {
            long leftMillis;
            if ((leftMillis = end - System.currentTimeMillis()) < 0L) continue;
            ExecutionUtils.runIgnore(() -> Thread.sleep(leftMillis));
        } while (System.currentTimeMillis() < end);
    }

    public static void waitEventLoop(int millis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long nanos = (long)millis * 1000000L;
            long start = System.nanoTime();
            do {
                ExecutionUtils.sleep(0);
                while (display.readAndDispatch()) {
                }
            } while (System.nanoTime() - start < nanos);
        } else {
            ExecutionUtils.sleep(millis);
        }
    }

    public static boolean runIgnore(RunnableEx runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean runLog(RunnableEx runnable) {
        try {
            runnable.run();
            return true;
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
            return false;
        }
    }

    public static void runRethrow(RunnableEx runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public static void runRethrow(RunnableEx runnable, String format, Object ... args) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            String message = String.format(format, args);
            throw new RuntimeException(message, e);
        }
    }

    public static void runDesignTime(RunnableEx runnable) throws Exception {
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            runnable.run();
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
    }

    public static <T> T runDesignTime(Callable<T> runnable) throws Exception {
        boolean old_designTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(true);
            T t = runnable.call();
            return t;
        }
        finally {
            Beans.setDesignTime(old_designTime);
        }
    }

    public static boolean runLogUI(final RunnableEx runnable) {
        final boolean[] success = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                success[0] = ExecutionUtils.runLog(runnable);
            }
        });
        return success[0];
    }

    public static void runRethrowUI(final RunnableEx runnable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runRethrow(runnable);
            }
        });
    }

    public static <T> T runObjectUI(Callable<T> runnable) {
        Object[] result = new Object[1];
        ExecutionUtils.runRethrowUI(() -> {
            Object t = ExecutionUtils.runObject(runnable);
        });
        return (T)result[0];
    }

    public static CompletableFuture<Void> runLogLater(RunnableEx runnable) {
        return CompletableFuture.runAsync(() -> {
            boolean bl = ExecutionUtils.runLog(runnable);
        }, arg_0 -> ((Display)Display.getDefault()).asyncExec(arg_0));
    }

    public static <T> T runObject(Callable<T> runnable) {
        try {
            return runnable.call();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public static <T> T runObject(ObjectInfo object, Callable<T> runnable) {
        Object[] result = new Object[1];
        ExecutionUtils.run(object, () -> {
            Object v = runnable.call();
        });
        return (T)result[0];
    }

    public static <T> T runObject(Callable<T> runnable, String format, Object ... args) {
        try {
            return runnable.call();
        }
        catch (Throwable e) {
            String message = String.format(format, args);
            throw new Error(message, e);
        }
    }

    public static <T> T runObjectIgnore(Callable<T> runnable, T defaultValue) {
        try {
            return runnable.call();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static <T> T runObjectLog(Callable<T> runnable, T defaultValue) {
        try {
            return runnable.call();
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
            return defaultValue;
        }
    }

    public static boolean run(ObjectInfo objectInfo, RunnableEx runnable) {
        try {
            objectInfo.startEdit();
            runnable.run();
            objectInfo.endEdit();
            return true;
        }
        catch (Throwable e) {
            IDesignPageSite site = IDesignPageSite.Helper.getSite(objectInfo);
            if (site != null) {
                site.handleException(e);
                return false;
            }
            throw ReflectionUtils.propagate(e);
        }
    }

    public static void refresh(ObjectInfo objectInfo) {
        ExecutionUtils.run(objectInfo, () -> {});
    }

    public static void runLater(final ObjectInfo objectInfo, final RunnableEx runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.run(objectInfo, runnable);
            }
        });
    }
}

