/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.nonvisual;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.part.nonvisual.NonVisualBeanEditPart;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;

final class NonVisualValidator
implements ILayoutRequestValidator {
    protected final JavaInfo m_infoForMemento;

    public NonVisualValidator(JavaInfo infoForMemento) {
        this.m_infoForMemento = infoForMemento;
    }

    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        if (!NonVisualValidator.acceptDropNonVisualBeans()) {
            return false;
        }
        Object newObject = request.getNewObject();
        if (newObject instanceof JavaInfo) {
            return (Boolean)ExecutionUtils.runObjectLog(() -> {
                JavaInfo newInfo = (JavaInfo)((Object)((Object)newObject));
                return NonVisualValidator.validateJavaInfo(newInfo);
            }, (Object)false);
        }
        return false;
    }

    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        if (!NonVisualValidator.acceptDropNonVisualBeans()) {
            return false;
        }
        return (Boolean)ExecutionUtils.runObjectLog(() -> {
            List mementos = (List)request.getMemento();
            if (mementos.size() == 1) {
                JavaInfo newInfo = ((JavaInfoMemento)mementos.get(0)).create(this.m_infoForMemento);
                return NonVisualValidator.validateJavaInfo(newInfo);
            }
            return false;
        }, (Object)false);
    }

    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        return this.validateMoveRequest(host, request);
    }

    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        for (EditPart part : request.getEditParts()) {
            if (part instanceof NonVisualBeanEditPart) continue;
            return false;
        }
        return true;
    }

    protected static boolean validateJavaInfo(JavaInfo newInfo) throws Exception {
        ComponentDescription description = newInfo.getDescription();
        if (description.getComponentClass() == null) {
            return false;
        }
        if (JavaInfoUtils.hasTrueParameter(newInfo, "NVO.disabled")) {
            return false;
        }
        String source = newInfo.getCreationSupport().add_getSource(null);
        return !StringUtils.contains((CharSequence)source, (CharSequence)"%parent%") && !StringUtils.contains((CharSequence)source, (CharSequence)"%child%");
    }

    protected static boolean acceptDropNonVisualBeans() {
        return DesignerPlugin.getPreferences().getBoolean("common.acceptNonVisualBeans");
    }
}

