/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.php.composer.api.ComposerConstants;
import org.eclipse.php.composer.api.DistributedPackage;
import org.eclipse.php.composer.api.annotation.Name;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.collection.License;
import org.eclipse.php.composer.api.collection.Persons;
import org.eclipse.php.composer.api.collection.Repositories;
import org.eclipse.php.composer.api.collection.Scripts;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.objects.Config;
import org.eclipse.php.composer.api.objects.Extra;
import org.eclipse.php.composer.api.objects.Support;

public class ComposerPackage
extends DistributedPackage {
    private Dependencies require = new Dependencies();
    @Name(value="require-dev")
    private Dependencies requireDev = new Dependencies();
    private Repositories repositories = new Repositories();
    private Support support = new Support();
    private License license = new License();
    private Persons authors = new Persons();
    private Extra extra = new Extra();
    private Config config = new Config();
    private Scripts scripts = new Scripts();

    public ComposerPackage() {
        this.listen();
    }

    public ComposerPackage(Object json) {
        this();
        this.fromJson(json);
    }

    public ComposerPackage(String json) throws ParseException {
        this();
        this.fromJson(json);
    }

    public ComposerPackage(File file) throws IOException, ParseException {
        this();
        this.fromJson(file);
    }

    public ComposerPackage(Reader reader) throws IOException, ParseException {
        this();
        this.fromJson(reader);
    }

    @Override
    protected List<String> getOwnProperties() {
        String[] props = new String[]{"keywords", "bin"};
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(props));
        list.addAll(super.getOwnProperties());
        return list;
    }

    public String getHomepage() {
        return this.getAsString("homepage");
    }

    public void setHomepage(String homepage) {
        this.set("homepage", homepage);
    }

    public Dependencies getRequire() {
        return this.require;
    }

    public Dependencies getRequireDev() {
        return this.requireDev;
    }

    public String getTargetDir() {
        return this.getAsString("target-dir");
    }

    public void setTargetDir(String targetDir) {
        this.set("target-dir", targetDir);
    }

    public String getVersionNormalized() {
        return this.getAsString("version_normalized");
    }

    public License getLicense() {
        return this.license;
    }

    public JsonArray getKeywords() {
        return this.getAsArray("keywords");
    }

    public String getMinimumStability() {
        String stabi = this.getAsString("minimum-stability");
        if (stabi == null) {
            return ComposerConstants.STABILITIES[0];
        }
        return stabi;
    }

    public void setMinimumStability(String minimumStability) {
        this.set("minimum-stability", minimumStability);
    }

    public Persons getAuthors() {
        return this.authors;
    }

    public Support getSupport() {
        return this.support;
    }

    public Repositories getRepositories() {
        return this.repositories;
    }

    public Extra getExtra() {
        return this.extra;
    }

    public Config getConfig() {
        return this.config;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public JsonArray getBin() {
        return this.getAsArray("bin");
    }

    public String toString() {
        return this.getName();
    }
}

