/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;

public class Trace
implements DebugOptionsListener {
    private static Set<String> logged = new HashSet<String>();
    public static boolean CONFIG = false;
    public static boolean WARNING = false;
    public static boolean SEVERE = false;
    public static boolean FINEST = false;
    public static boolean PUBLISHING = false;
    public static final String STRING_CONFIG = "/config";
    public static final String STRING_FINEST = "/finest";
    public static final String STRING_WARNING = "/warning";
    public static final String STRING_SEVERE = "/severe";
    public static final String STRING_PUBLISHING = "/publishing";

    public void optionsChanged(DebugOptions options) {
        CONFIG = options.getBooleanOption("org.eclipse.jst.server.core/config", false);
        WARNING = options.getBooleanOption("org.eclipse.jst.server.core/warning", false);
        SEVERE = options.getBooleanOption("org.eclipse.jst.server.core/severe", false);
        FINEST = options.getBooleanOption("org.eclipse.jst.server.core/finest", false);
        PUBLISHING = options.getBooleanOption("org.eclipse.jst.server.core/publishing", false);
    }

    public static void trace(String level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(String level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (STRING_SEVERE.equals(level) && !logged.contains(s)) {
            JavaServerPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.core", s, t));
            logged.add(s);
        }
        if (JavaServerPlugin.getInstance().isDebugging()) {
            System.out.println("org.eclipse.jst.server.core " + level + " " + s);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

