/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.webxml.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtils;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtilsForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.AbstractWebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ContextParamAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterMapperAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.FilterRemoverForJavaEE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ListenerAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletMappingAdderForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.operations.ServletRemoverForJavaEE;

public class WebXmlUpdaterForJ2EE
extends AbstractWebXmlUpdater {
    private final WebApp webApp;

    public WebXmlUpdaterForJ2EE(Object webAppObj, IProject project, IModelProvider provider, IProgressMonitor monitor) {
        super(webAppObj, project, provider, monitor);
        this.webApp = (WebApp)webAppObj;
    }

    @Override
    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.provider.modify((Runnable)new ServletAdderForJ2EE(this.project, servletName, servletClass, loadOnStartup), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.provider.modify((Runnable)new ServletMappingAdderForJ2EE(this.project, servletName, servletClass, urlPattern), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeServlet(String servletClassName) {
        Servlet servlet = WebXmlUtilsForJ2EE.findServlet(this.webApp, servletClassName);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot find servlet named \"" + servletClassName + "\"");
        }
        this.provider.modify((Runnable)new ServletRemoverForJavaEE(this.project, servletClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilter(String filterName, String filterClass) {
        this.provider.modify((Runnable)new FilterAdderForJ2EE(this.project, filterName, filterClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeFilter(String filterClassName) {
        Filter filter = WebXmlUtilsForJ2EE.findFilter(this.webApp, filterClassName);
        if (filter == null) {
            throw new IllegalArgumentException("Cannot find filter named \"" + filterClassName + "\"");
        }
        this.provider.modify((Runnable)new FilterRemoverForJavaEE(this.project, filterClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.provider.modify((Runnable)new FilterMapperAdderForJ2EE(this.project, filterName, filterClass, servletName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public String getContextParamValue(String paramName) {
        return WebXmlUtilsForJ2EE.getContextParamValue(this.webApp, paramName);
    }

    @Override
    public List<String> getContextParamValuesAsList(String paramName, String valuesDelimiterRegex) {
        return WebXmlUtilsForJ2EE.getContextParamValuesAsList(this.webApp, paramName, valuesDelimiterRegex);
    }

    @Override
    public void setContextParamValue(String paramName, String paramValue) {
        WebXmlUtilsForJ2EE.setContextParamValue(this.webApp, paramName, paramValue);
    }

    @Override
    public void addContextParam(String paramName, String paramValue, String description) {
        this.provider.modify((Runnable)new ContextParamAdderForJ2EE(this.project, paramName, paramValue, description), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addListener(String listenerClass) {
        this.provider.modify((Runnable)new ListenerAdderForJ2EE(this.project, listenerClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public Object getWebApp() {
        return this.webApp;
    }
}

