/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public abstract class DBStoreTable
extends Lifecycle {
    private final IDBStore store;
    private final String tableName;
    private IDBTable table;

    public DBStoreTable(IDBStore store, String tableName) {
        this.store = store;
        this.tableName = tableName;
    }

    public final IDBStore store() {
        return this.store;
    }

    public final IDBTable table() {
        return this.table;
    }

    public String toString() {
        return this.table == null ? this.tableName : this.table.toString();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IDBDatabase database = this.store.getDatabase();
        this.table = database.getSchema().getTable(this.tableName);
        if (this.table == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    DBStoreTable.this.table = schema.addTable(DBStoreTable.this.tableName);
                    DBStoreTable.this.firstActivate(DBStoreTable.this.table);
                }
            });
        } else {
            this.reActivate(this.table);
        }
        this.initSQL(this.table);
    }

    protected abstract void firstActivate(IDBTable var1);

    protected abstract void reActivate(IDBTable var1);

    protected void initSQL(IDBTable table) {
    }

    protected void doDeactivate() throws Exception {
        this.table = null;
        super.doDeactivate();
    }

    protected final IDBConnection getConnection() {
        return this.store.getDatabase().getConnection();
    }

    protected static IDBStoreAccessor accessor() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor == null) {
            throw new IllegalStateException("Can only be called from within a valid IDBStoreAccessor context");
        }
        return (IDBStoreAccessor)accessor;
    }
}

