/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.internal.ManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.DatabaseProviderHelper;
import org.eclipse.datatools.enablement.ibm.util.ConnectionProfileApp;
import org.eclipse.datatools.enablement.ibm.util.DBVersion;
import org.eclipse.datatools.enablement.ibm.util.SQLIdentifier;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class ConnectionProfileUtility {
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    public static final String GENERIC_JDBC = "Generic JDBC";
    public static final String GENERIC_JDBC_VERSION = "1.0";
    public static final String ALIAS_PROPERTY = "com.ibm.datatools.db2.ui.alias.aliasName";
    public static final String VERSON_INFO = "org.eclipse.datatools.connectivity.versionInfo";
    public static final String CATALOG_TYPE_PROPERTY_ID = "org.eclipse.datatools.enablement.oracle.catalogType";
    public static final String CATALOG_TYPE_VALUE_ALL = "ALL";
    public static final String CATALOG_TYPE_VALUE_DBA = "DBA";
    public static final String CATALOG_TYPE_VALUE_USER = "USER";
    private static final char[] OS_INVALID_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
    private static Map<Character, String> mappedSubstitutionCharacters;

    private static Map<Character, String> getSubstitutionMap() {
        if (mappedSubstitutionCharacters == null) {
            mappedSubstitutionCharacters = new HashMap<Character, String>();
            int i = 0;
            while (i < OS_INVALID_CHARACTERS.length) {
                mappedSubstitutionCharacters.put(Character.valueOf(OS_INVALID_CHARACTERS[i]), "_" + i);
                ++i;
            }
        }
        return mappedSubstitutionCharacters;
    }

    public static String getSafeProfileFileName(String profileName) {
        profileName = ConnectionProfileUtility.escapeProfileName(profileName);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < profileName.length()) {
            char current = profileName.charAt(i);
            String substitution = ConnectionProfileUtility.getSubstitutionMap().get(Character.valueOf(current));
            if (substitution != null) {
                builder.append(substitution);
            } else {
                builder.append(current);
            }
            ++i;
        }
        return builder.toString();
    }

    private static String escapeProfileName(String profileName) {
        Collection<String> reservedCharacters = ConnectionProfileUtility.getSubstitutionMap().values();
        for (String reserved : reservedCharacters) {
            profileName = ConnectionProfileUtility.escapeCharacter(reserved, profileName);
        }
        return profileName;
    }

    private static String escapeCharacter(String reservedCharacter, String profileName) {
        StringBuilder builder = new StringBuilder();
        String[] pieces = profileName.split(reservedCharacter);
        int count = 0;
        String[] stringArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            String piece = stringArray[n2];
            builder.append(piece);
            if (count != pieces.length - 1) {
                builder.append("_" + reservedCharacter);
            }
            ++count;
            ++n2;
        }
        if (profileName.endsWith(reservedCharacter)) {
            builder.append("_" + reservedCharacter);
        }
        return builder.toString();
    }

    public static boolean isConnected(IConnectionProfile profile) {
        if (profile == null) {
            return false;
        }
        return profile.getConnectionState() == 1;
    }

    public static boolean isWorkingOffline(IConnectionProfile profile) {
        if (profile == null) {
            return false;
        }
        return profile.getConnectionState() == 2;
    }

    public static ConnectionInfo getConnectionInfo(IConnectionProfile profile) {
        return ConnectionProfileUtility.getConnectionInfo(profile, true);
    }

    public static ConnectionInfo getConnectionInfo(IConnectionProfile profile, boolean okToConnect) {
        if (profile != null) {
            if (profile instanceof ConnectionProfileApp) {
                return ((ConnectionProfileApp)profile).getConnectionInfo();
            }
            boolean haveCon = false;
            if (okToConnect && !ConnectionProfileUtility.isConnected(profile)) {
                if (ConnectionProfileUtility.arePropertiesComplete(profile)) {
                    IStatus status = profile.connectWithoutJob();
                    haveCon = status.isOK();
                }
            } else if (ConnectionProfileUtility.isConnected(profile) || ConnectionProfileUtility.isWorkingOffline(profile)) {
                haveCon = true;
            }
            if (haveCon) {
                Map factories = null;
                if (profile.getProvider() != null) {
                    factories = profile.getProvider().getConnectionFactories();
                }
                if (factories != null && factories.containsKey(Connection.class.getName())) {
                    Object rawCon;
                    IConnection iconn;
                    IManagedConnection managedConnection = profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
                    if (managedConnection == null) {
                        String conName = profile.getName();
                        managedConnection = new ManagedConnection(profile, conName);
                    }
                    if (managedConnection != null && (iconn = managedConnection.getConnection()) != null && (rawCon = iconn.getRawConnection()) instanceof ConnectionInfo) {
                        return (ConnectionInfo)rawCon;
                    }
                }
            }
        }
        return null;
    }

    public static String[] getVendorVersion(IConnectionProfile profile) {
        String[] vendorVersion = new String[2];
        try {
            Properties properties = profile.getBaseProperties();
            vendorVersion[0] = properties.getProperty("org.eclipse.datatools.connectivity.db.vendor");
            vendorVersion[1] = properties.getProperty("org.eclipse.datatools.connectivity.db.version");
            if (vendorVersion[0] == null && (properties = profile.getProperties(VERSON_INFO)) != null) {
                vendorVersion[0] = properties.getProperty("server.version");
            }
            if (vendorVersion[1] == null && (properties = profile.getProperties(VERSON_INFO)) != null) {
                vendorVersion[1] = properties.getProperty("server.name");
            }
            if (vendorVersion[0] == null) {
                vendorVersion[0] = "DB2 UDB";
            }
            if (vendorVersion[1] == null) {
                vendorVersion[1] = "V9.5";
            }
        }
        catch (Exception exception) {
            vendorVersion[0] = GENERIC_JDBC;
            vendorVersion[1] = GENERIC_JDBC_VERSION;
        }
        return vendorVersion;
    }

    public static Properties getVersionInfo(IConnectionProfile profile) {
        if (profile != null) {
            return profile.getProperties(VERSON_INFO);
        }
        return null;
    }

    public static boolean arePropertiesComplete(IConnectionProfile profile) {
        DatabaseDefinition dbDef;
        boolean isComplete = false;
        String providerID = ConnectionProfileUtility.getProviderID(profile);
        isComplete = providerID != null ? profile.arePropertiesComplete(providerID) : profile.arePropertiesComplete();
        if (!isComplete && DBVersion.isDBCloudscape(dbDef = ConnectionProfileUtility.getDatabaseDefinition(profile))) {
            boolean nouid = false;
            boolean nopwd = false;
            String[] up = ConnectionProfileUtility.getUidPwd(profile);
            if (up[0] == null || up[0].length() == 0) {
                nouid = true;
                ConnectionProfileUtility.setUID(profile, "dummy");
            }
            if (up[1] == null || up[1].length() == 0) {
                nopwd = true;
                ConnectionProfileUtility.setPassword(profile, "dummy");
            }
            isComplete = providerID != null ? profile.arePropertiesComplete(providerID) : profile.arePropertiesComplete();
            if (nouid) {
                ConnectionProfileUtility.setUID(profile, "");
            }
            if (nopwd) {
                ConnectionProfileUtility.setPassword(profile, "");
            }
        }
        return isComplete;
    }

    public static boolean useClientAuthentication(IConnectionProfile profile) {
        String url = ConnectionProfileUtility.getURL(profile);
        return url.indexOf("securityMechanism=4") > -1;
    }

    public static String[] getUidPwd(IConnectionProfile profile) {
        String[] uidPwd = new String[2];
        try {
            DriverInstance driverInstance;
            Properties properties = profile.getBaseProperties();
            uidPwd[0] = properties.getProperty("org.eclipse.datatools.connectivity.db.username");
            uidPwd[1] = properties.getProperty("org.eclipse.datatools.connectivity.db.password");
            if ((uidPwd[0] == null || uidPwd[0].length() == 0 || uidPwd[1] == null || uidPwd[1].length() == 0) && (driverInstance = ConnectionProfileUtility.getDriverInstance(profile)) != null) {
                if (uidPwd[0] == null || uidPwd[0].length() == 0) {
                    uidPwd[0] = driverInstance.getProperty("org.eclipse.datatools.connectivity.db.username");
                }
                if (uidPwd[1] == null || uidPwd[1].length() == 0) {
                    uidPwd[1] = driverInstance.getProperty("org.eclipse.datatools.connectivity.db.password");
                }
            }
        }
        catch (Exception exception) {
            uidPwd[0] = System.getProperty("user.name");
            uidPwd[1] = null;
        }
        return uidPwd;
    }

    public static String getUID(IConnectionProfile profile) {
        String uid = null;
        try {
            DriverInstance driverInstance;
            Properties properties = profile.getBaseProperties();
            uid = properties.getProperty("org.eclipse.datatools.connectivity.uid");
            if (uid == null || uid.length() == 0) {
                uid = properties.getProperty("org.eclipse.datatools.connectivity.db.username");
            }
            if ((uid == null || uid.length() == 0) && (driverInstance = ConnectionProfileUtility.getDriverInstance(profile)) != null) {
                uid = driverInstance.getProperty("org.eclipse.datatools.connectivity.db.username");
            }
        }
        catch (Exception exception) {
            uid = System.getProperty("user.name");
        }
        return uid;
    }

    public static void setUID(IConnectionProfile profile, String uid) {
        Properties properties = profile.getBaseProperties();
        properties.setProperty("org.eclipse.datatools.connectivity.uid", uid);
    }

    public static void setPassword(IConnectionProfile profile, String pwd) {
        Properties properties = profile.getBaseProperties();
        properties.setProperty("org.eclipse.datatools.connectivity.pwd", pwd);
    }

    public static String getURL(IConnectionProfile profile) {
        String url = null;
        try {
            Properties properties = profile.getBaseProperties();
            url = properties.getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        catch (Exception exception) {
            url = "";
        }
        return url;
    }

    public static String getDriverDefinitionID(IConnectionProfile profile) {
        Properties properties = profile.getBaseProperties();
        return properties.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public static String getDriverClass(IConnectionProfile profile) {
        Properties properties = profile.getBaseProperties();
        return properties.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public static String getProviderID(IConnectionProfile profile) {
        String id = null;
        IConnectionProfileProvider provider = profile.getProvider();
        if (provider != null) {
            id = provider.getId();
        }
        return id;
    }

    public static String getDriverDefinitionType(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
    }

    public static String getSavePassword(IConnectionProfile profile) {
        String save = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.savePWD");
        if (save == null) {
            return FALSE_VALUE;
        }
        return save;
    }

    public static boolean isPasswordSaved(IConnectionProfile profile) {
        String opt = ConnectionProfileUtility.getSavePassword(profile);
        return opt.equals(TRUE_VALUE);
    }

    public static String getConnectionProperties(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
    }

    public static String getOracleConnectionType(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty(CATALOG_TYPE_PROPERTY_ID);
    }

    public static String getDefaultSchema(IConnectionProfile profile) {
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.defaultSchema");
    }

    public static String getDriverPath(IConnectionProfile profile) {
        DriverInstance driverInstance;
        String driverPath = null;
        if (profile instanceof ConnectionProfileApp) {
            driverPath = ((ConnectionProfileApp)profile).getLoadingPath();
        }
        if (driverPath == null && (driverInstance = ConnectionProfileUtility.getDriverInstance(profile)) != null) {
            driverPath = driverInstance.getJarList();
        }
        if (driverPath == null) {
            driverPath = profile.getBaseProperties().getProperty("jarList");
        }
        return driverPath;
    }

    public static DriverInstance getDriverInstance(IConnectionProfile profile) {
        String driverID;
        DriverInstance driverInstance = null;
        if (!(profile instanceof ConnectionProfileApp) && (driverID = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID")) != null) {
            try {
                driverInstance = DriverManager.getInstance().getDriverInstanceByID(driverID);
            }
            catch (Throwable throwable) {}
        }
        return driverInstance;
    }

    public static DatabaseDefinition getDatabaseDefinition(ConnectionInfo info) {
        return info.getDatabaseDefinition();
    }

    public static DatabaseDefinition getDatabaseDefinition(IConnectionProfile profile) {
        if (profile instanceof ConnectionProfileApp) {
            ConnectionInfo conInfo = ((ConnectionProfileApp)profile).getConnectionInfo();
            return conInfo.getDatabaseDefinition();
        }
        String[] vendorVersion = ConnectionProfileUtility.getVendorVersion(profile);
        RDBCorePlugin rdbc = RDBCorePlugin.getDefault();
        DatabaseDefinitionRegistry defRegistry = null;
        if (rdbc != null) {
            defRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        }
        DatabaseDefinition dbDef = null;
        if (defRegistry != null) {
            dbDef = defRegistry.getDefinition(vendorVersion[0], vendorVersion[1]);
        }
        if (dbDef == null && defRegistry != null && (dbDef = defRegistry.getDefinition(GENERIC_JDBC, GENERIC_JDBC_VERSION)) == null) {
            vendorVersion[0] = "DB2 UDB";
            vendorVersion[1] = "V9.5";
            dbDef = defRegistry.getDefinition(vendorVersion[0], vendorVersion[1]);
        }
        return dbDef;
    }

    public static char getDelimiter(IConnectionProfile profile) {
        DatabaseDefinition dbDef = ConnectionProfileUtility.getDatabaseDefinition(profile);
        return SQLIdentifier.getDelimiter(dbDef);
    }

    public static String getDatabaseName(IConnectionProfile profile) {
        String databaseName = null;
        try {
            Properties properties = profile.getBaseProperties();
            databaseName = properties.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        catch (Exception exception) {
            databaseName = null;
        }
        if ((databaseName == null || databaseName.trim().length() == 0) && profile != null) {
            databaseName = profile.getName();
        }
        return databaseName;
    }

    public static String getAlias(IConnectionProfile profile) {
        String alias = null;
        try {
            Properties properties = profile.getBaseProperties();
            alias = properties.getProperty(ALIAS_PROPERTY);
        }
        catch (Exception exception) {
            alias = null;
        }
        return alias;
    }

    public static Database getDatabase(IConnectionProfile profile) {
        Database db = null;
        ConnectionInfo conInfo = ConnectionProfileUtility.getConnectionInfo(profile);
        if (conInfo != null && (db = conInfo.getSharedDatabase()) == null) {
            db = conInfo.getCachedDatabase();
        }
        return db;
    }

    public static String getDefaultPath(IConnectionProfile profile) {
        StringBuffer defaultPath = new StringBuffer();
        DBVersion version = DBVersion.getSharedInstance(profile);
        String userId = ConnectionProfileUtility.getUID(profile);
        if (userId == null || userId.length() == 0) {
            userId = System.getProperty("user.name");
        }
        DatabaseDefinition dbdef = ConnectionProfileUtility.getDatabaseDefinition(profile);
        userId = SQLIdentifier.toCatalogFormat(userId, dbdef);
        if (version.isUNO()) {
            defaultPath.append("SYSIBM,SYSFUN,SYSPROC,SYSIBMADM");
        } else if (version.isDB390()) {
            defaultPath.append("SYSIBM,SYSFUN,SYSPROC");
        } else if (version.isDB400()) {
            defaultPath.append("QSYS,QSYS2,SYSPROC,SYSIBMADM");
        }
        if (defaultPath.length() > 0) {
            defaultPath.append(',');
        }
        defaultPath.append(userId);
        return defaultPath.toString();
    }

    public static String[] getPathKeywordSuggestions(IConnectionProfile profile) {
        String[] keywords = null;
        DBVersion version = DBVersion.getSharedInstance(profile);
        if (version.isUNO()) {
            keywords = new String[]{"\"SYSTEM PATH\"", CATALOG_TYPE_VALUE_USER, "CURRENT_PATH", "\"CURRENT PATH\"", "\"CURRENT PACKAGE PATH\""};
        } else if (version.isDB390()) {
            keywords = new String[]{"\"SYSTEM PATH\"", "SESSION_USER", CATALOG_TYPE_VALUE_USER, "PATH", "\"CURRENT PATH\"", "\"CURRENT PACKAGE PATH\""};
        } else if (version.isDB400()) {
            keywords = new String[]{"\"SYSTEM PATH\"", "SESSION_USER", CATALOG_TYPE_VALUE_USER, "SYSTEM_USER", "PATH", "\"CURRENT PATH\"", "\"CURRENT FUNCTION PATH\"", "CURRENT_PATH"};
        }
        return keywords;
    }

    public static boolean testConnection(ConnectionInfo coninfo, StringBuffer msg) {
        Connection testConn;
        boolean ok = true;
        if (coninfo != null && (testConn = coninfo.getSharedConnection()) == null) {
            try {
                IConnectionProfile profile = coninfo.getConnectionProfile();
                IStatus status = profile.connectWithoutJob();
                if (!status.isOK()) {
                    ok = false;
                } else {
                    testConn = coninfo.getSharedConnection();
                    if (testConn != null) {
                        String dbname = ConnectionProfileUtility.getDatabaseName(profile);
                        new DatabaseProviderHelper().setDatabase(testConn, coninfo, dbname);
                    }
                }
            }
            catch (Exception e) {
                msg.append(e.getMessage());
                ok = false;
            }
        }
        return ok;
    }

    public static boolean isInConnectedState(ConnectionInfo conInfo) {
        IConnectionProfile profile = conInfo.getConnectionProfile();
        return ConnectionProfileUtility.isConnected(profile) || ConnectionProfileUtility.isWorkingOffline(profile);
    }

    public static Connection getConnection(IConnectionProfile profile) {
        IManagedConnection managedConnection;
        Connection conn = null;
        if (profile.getConnectionState() != 1) {
            profile.connect();
        }
        if ((managedConnection = profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo")) != null) {
            ConnectionInfo cInfo = (ConnectionInfo)managedConnection.getConnection().getRawConnection();
            conn = cInfo.getSharedConnection();
        }
        return conn;
    }

    public static String[] parseURL(String url) {
        if (url != null) {
            String[] elements = new String[6];
            try {
                int slash;
                int colon = url.indexOf(58);
                elements[0] = url.substring(0, colon);
                String remainingURL = url.substring(colon + 1);
                colon = remainingURL.indexOf(58);
                elements[1] = remainingURL.substring(0, colon);
                remainingURL = remainingURL.substring(colon + 1);
                if (remainingURL.startsWith("//")) {
                    remainingURL = remainingURL.substring(2);
                }
                if ((slash = remainingURL.indexOf(47)) > -1) {
                    elements[2] = remainingURL.substring(0, slash);
                    if (elements[2].indexOf(91) > -1 && elements[2].indexOf("]:") > -1) {
                        elements[3] = elements[2].substring(elements[2].indexOf("]:") + 2);
                        elements[2] = elements[2].substring(1, elements[2].indexOf("]:"));
                    } else if (elements[2].indexOf(58) > -1) {
                        elements[3] = elements[2].substring(elements[2].indexOf(58) + 1);
                        elements[2] = elements[2].substring(0, elements[2].indexOf(58));
                    }
                    remainingURL = remainingURL.substring(slash + 1);
                }
                if (!elements[1].equalsIgnoreCase("db2")) {
                    int semi = remainingURL.indexOf(59);
                    if (semi > -1) {
                        elements[2] = remainingURL.substring(0, semi);
                        elements[5] = remainingURL.substring(semi + 1);
                    } else {
                        elements[2] = remainingURL;
                    }
                } else {
                    colon = remainingURL.indexOf(58);
                    if (colon > -1) {
                        elements[4] = remainingURL.substring(0, colon);
                        elements[5] = remainingURL = remainingURL.substring(colon + 1);
                    } else {
                        elements[4] = remainingURL;
                    }
                }
            }
            catch (Exception exception) {}
            int i = 0;
            while (i < 6) {
                if (elements[i] == null) {
                    elements[i] = "";
                }
                ++i;
            }
            if (elements[2].equals("127.0.0.1")) {
                elements[2] = "localhost";
            }
            return elements;
        }
        return null;
    }

    public static String getDefaultPath(DBVersion version, String currentSchema) {
        StringBuffer defaultPath = new StringBuffer();
        if (version.isUNO()) {
            defaultPath.append("SYSIBM,SYSFUN,SYSPROC,SYSIBMADM");
        } else if (version.isDB390()) {
            defaultPath.append("SYSIBM,SYSFUN,SYSPROC");
        } else if (version.isDB400()) {
            defaultPath.append("QSYS,QSYS2,SYSPROC,SYSIBMADM");
        }
        if (defaultPath.length() > 0) {
            defaultPath.append(',');
        }
        defaultPath.append(currentSchema);
        return defaultPath.toString();
    }
}

