/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;

public class XMLCatalogURIResolverExtension
implements URIResolverExtension {
    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (catalog == null) {
            Logger.log(204, XMLCoreMessages.Catalog_resolution_null_catalog);
            return null;
        }
        String resolved = null;
        if (systemId != null) {
            try {
                resolved = catalog.resolveSystem(systemId);
                if (resolved == null) {
                    resolved = catalog.resolveURI(systemId);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.log(204, XMLCoreMessages.Catalog_resolution_malformed_url);
                resolved = null;
            }
            catch (IOException iOException) {
                Logger.log(204, XMLCoreMessages.Catalog_resolution_io_exception);
                resolved = null;
            }
        }
        if (!(resolved != null || publicId == null || systemId != null && systemId.endsWith(".xsd"))) {
            try {
                resolved = catalog.resolvePublic(publicId, systemId);
                if (resolved == null) {
                    resolved = catalog.resolveURI(publicId);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.log(204, XMLCoreMessages.Catalog_resolution_malformed_url);
                resolved = null;
            }
            catch (IOException iOException) {
                Logger.log(204, XMLCoreMessages.Catalog_resolution_io_exception);
                resolved = null;
            }
        }
        return resolved;
    }
}

