/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ContainerSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.SourceNameMapperContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.VProjectSourceContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.util.PlatformUtil;

public class ReverseSourceLookup {
    private final ISourceLookupDirector sourceDirector;

    public ReverseSourceLookup(ISourceLookupDirector sourceDirector) {
        this.sourceDirector = sourceDirector;
    }

    public VmResourceId findVmResource(IFile sourceFile) throws CoreException {
        ISourceContainer[] iSourceContainerArray = this.sourceDirector.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            VmResourceId scriptName = this.tryForContainer(sourceFile, container);
            if (scriptName != null) {
                return scriptName;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isGoodTargetContainer(ISourceContainer container) {
        return ReverseSourceLookup.wrapNonVirtualContainer(container) != null;
    }

    private VmResourceId tryForContainer(IFile sourceFile, ISourceContainer container) throws CoreException {
        if (container.isComposite() && this.isSupportedCompositeContainer(container)) {
            ISourceContainer[] subContainers;
            ISourceContainer[] iSourceContainerArray = subContainers = container.getSourceContainers();
            int n = subContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer subContainer = iSourceContainerArray[n2];
                VmResourceId res = this.tryForContainer(sourceFile, subContainer);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
            return null;
        }
        if (container instanceof VProjectSourceContainer) {
            VProjectSourceContainer projectSourceContainer = (VProjectSourceContainer)container;
            return projectSourceContainer.findScriptId(sourceFile);
        }
        String name = this.tryForNonVirtualContainer(sourceFile, container);
        if (name == null) {
            return null;
        }
        return new VmResourceId(name, null);
    }

    private boolean isSupportedCompositeContainer(ISourceContainer container) {
        return container instanceof DefaultSourceContainer;
    }

    private String tryForNonVirtualContainer(IFile resource, ISourceContainer container) {
        ContainerWrapper wrapper = ReverseSourceLookup.wrapNonVirtualContainer(container);
        if (wrapper == null) {
            return null;
        }
        return wrapper.lookup(resource);
    }

    private static ContainerWrapper wrapNonVirtualContainer(ISourceContainer container) {
        if (container instanceof ContainerSourceContainer) {
            final ContainerSourceContainer containerSourceContainer = (ContainerSourceContainer)container;
            return new ContainerWrapper(){

                @Override
                public String lookup(IFile resource) {
                    return ReverseSourceLookup.lookupInResourceContainer(resource, containerSourceContainer.getContainer());
                }
            };
        }
        if (container instanceof WorkspaceSourceContainer) {
            return new ContainerWrapper(){

                @Override
                public String lookup(IFile resource) {
                    return ReverseSourceLookup.lookupInResourceContainer(resource, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
                }
            };
        }
        if (container instanceof SourceNameMapperContainer) {
            SourceNameMapperContainer mappingContainer = (SourceNameMapperContainer)container;
            final ContainerWrapper targetContainerWrapper = ReverseSourceLookup.wrapNonVirtualContainer(mappingContainer.getTargetContainer());
            final String prefix = mappingContainer.getPrefix();
            return new ContainerWrapper(){

                @Override
                public String lookup(IFile resource) {
                    String subResult;
                    String string = subResult = targetContainerWrapper == null ? null : targetContainerWrapper.lookup(resource);
                    if (subResult == null) {
                        return null;
                    }
                    if (PlatformUtil.isWindows() && prefix.contains("\\")) {
                        subResult = subResult.replace("/", "\\");
                    }
                    return String.valueOf(prefix) + subResult;
                }
            };
        }
        return null;
    }

    private static String lookupInResourceContainer(IFile resource, IContainer resourceContainer) {
        IPath resourceFullPath = resource.getFullPath();
        IPath containerFullPath = resourceContainer.getFullPath();
        if (!containerFullPath.isPrefixOf(resourceFullPath)) {
            return null;
        }
        int offset = containerFullPath.segmentCount();
        IPath newPath = resourceFullPath.removeFirstSegments(offset);
        return newPath.toPortableString();
    }

    private static interface ContainerWrapper {
        public String lookup(IFile var1);
    }
}

