/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.handlers;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.handlers.IMissingConnectionHandler;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;

public class CommonMissingConnectionHandler
implements IMissingConnectionHandler {
    private static long lastMissingConnectiontDialogTimeStamp = 0L;
    private static final long timeBetweenDialogs = 5000L;

    public void handle(final IRemoteConnectionType connectionType, final String connectionName) {
        RDTSyncUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IRemoteUIConnectionService connectionServices;
                if (System.currentTimeMillis() - lastMissingConnectiontDialogTimeStamp <= 5000L) {
                    return;
                }
                lastMissingConnectiontDialogTimeStamp = System.currentTimeMillis();
                String[] buttonLabels = new String[]{IDialogConstants.OK_LABEL, Messages.CommonMissingConnectionHandler_6};
                String newline = System.getProperty("line.separator");
                MessageDialog dialog = new MessageDialog(null, Messages.CommonMissingConnectionHandler_0, null, String.valueOf(Messages.CommonMissingConnectionHandler_1) + connectionName + Messages.CommonMissingConnectionHandler_2 + newline + newline + Messages.CommonMissingConnectionHandler_3 + newline + Messages.CommonMissingConnectionHandler_4 + newline + Messages.CommonMissingConnectionHandler_5, 1, buttonLabels, 0);
                int buttonPressed = dialog.open();
                if (buttonPressed == 1 && (connectionServices = (IRemoteUIConnectionService)connectionType.getService(IRemoteUIConnectionService.class)) != null) {
                    IRemoteUIConnectionWizard wizard = connectionServices.getConnectionWizard(dialog.getShell());
                    wizard.setConnectionName("Remote Host");
                    IRemoteConnectionWorkingCopy wc = wizard.open();
                    try {
                        wc.save();
                    }
                    catch (RemoteConnectionException e) {
                        RDTSyncUIPlugin.log(e);
                    }
                }
            }
        });
    }
}

