/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.preferences.WSIComplianceUtils;

public class ValidateWSIComplianceCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameter javaWSDLParam = null;
    private Vector status = null;
    private IProject serviceProject_ = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            IStatus simpleStatus = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(simpleStatus);
            return simpleStatus;
        }
        this.status = new Vector();
        PersistentWSIContext wsiContext = new PersistentWSIContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)this.serviceProject_, (PersistentWSIContext)wsiContext);
        this.checkRPCEncoded(severity);
        Status[] statuses = this.status.toArray(new Status[this.status.size()]);
        if (statuses.length == 0 || WSIComplianceUtils.checkWSICompliance((IStatusHandler)environment.getStatusHandler(), (Status[])statuses, (IProject)this.serviceProject_, (PersistentWSIContext)wsiContext)) {
            return Status.OK_STATUS;
        }
        return StatusUtils.errorStatus((String)"");
    }

    private void checkRPCEncoded(int severity) {
        if ("RPC".equals(this.javaWSDLParam.getStyle()) && "ENCODED".equals(this.javaWSDLParam.getUse())) {
            this.status.add(new Status(severity, "ValidateWSIComplianceCommand", 0, AxisCreationUIMessages.WSI_INCOMPLIANCE_RPC_ENCODED, null));
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServiceProject(IProject serviceProject_) {
        this.serviceProject_ = serviceProject_;
    }
}

