/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*    mwenz - Bug 352440 - Fixed deprecation warnings - contributed by Felix Velasco
*    mwenz - Bug 477421 - SWTException in ScaledGraphics.getCachedFontData
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.ui.internal.fixed;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;

/**
 * The Class FixedScalableFreeformLayeredPane.
 * 
 * @noinstantiate This class is not intended to be instantiated by clients.
 * @noextend This class is not intended to be subclassed by clients.
 */
public class FixedScalableFreeformLayeredPane extends ScalableFreeformLayeredPane {
	/**
	 * Paint client area.
	 * 
	 * Change from super method: Do not call the super method in case of scale
	 * == 1.0; instead always use FixedScaledGraphics for consistency. Also
	 * check disposed state of FixedScaledGraphics.
	 * 
	 * @param graphics
	 *            the graphics
	 * 
	 * @see org.eclipse.draw2d.Figure#paintClientArea(Graphics)
	 */
	@Override
	protected void paintClientArea(Graphics graphics) {
		if (getChildren().isEmpty()) {
			return;
		}
		FixedScaledGraphics g = new FixedScaledGraphics(graphics);
		boolean optimizeClip = getBorder() == null || getBorder().isOpaque();
		if (!optimizeClip)
			g.clipRect(getBounds().getShrinked(getInsets()));
		g.scale(getScale());
		g.pushState();
		if (!g.isDisposed()) {
			paintChildren(g);
			g.dispose();
		}
		graphics.restoreState();
	}
}
