/*******************************************************************************
 * Copyright (c) 2015 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.parsley.widgets;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * An implementation that creates widgets suitable for dialogs.
 *
 * @author Lorenzo Bettini - Initial contribution and API
 *
 */
public class DialogWidgetFactory extends AbstractWidgetFactory {

	@Override
	public Label createLabel(Composite parent, String text) {
		Label label = new Label(parent, SWT.NONE);
		label.setText(text);
		return label;
	}

	@Override
	public Button createButton(Composite parent, String text, int style) {
		Button button = new Button(parent, style);
		button.setText(text);
		return button;
	}

	@Override
	public Text createText(Composite parent, String text, int style) {
		Text t = new Text(parent, style);
		t.setText(text);
		return t;
	}

	@Override
	public ComboViewer createComboViewer(Composite parent, int style) {
		return new ComboViewer(parent, style);
	}

	@Override
	public DateTime createDateTime(Composite parent, int style) {
		return new DateTime(parent, style);
	}
}
