/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.net4j.util.ref.Interner;

public final class NormalCDOLockOwner
implements CDOLockOwner {
    private static final NormalInterner INTERNER = new NormalInterner();
    private final int sessionID;
    private final int viewID;

    private NormalCDOLockOwner(int sessionID, int viewID) {
        this.sessionID = sessionID;
        this.viewID = viewID;
    }

    @Override
    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public int getViewID() {
        return this.viewID;
    }

    @Override
    public String getDurableLockingID() {
        return null;
    }

    @Override
    public boolean isDurableView() {
        return false;
    }

    public int hashCode() {
        return NormalCDOLockOwner.getHashCode(this.sessionID, this.viewID);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CDOLockOwner[");
        builder.append(this.sessionID);
        builder.append(':');
        builder.append(this.viewID);
        builder.append(']');
        return builder.toString();
    }

    public static NormalCDOLockOwner create(int sessionID, int viewID) {
        return INTERNER.intern(sessionID, viewID);
    }

    private static int getHashCode(int sessionID, int viewID) {
        return 31 * (31 + sessionID) + viewID;
    }

    /* synthetic */ NormalCDOLockOwner(int n, int n2, NormalCDOLockOwner normalCDOLockOwner) {
        this(n, n2);
    }

    private static final class NormalInterner
    extends Interner<NormalCDOLockOwner> {
        private NormalInterner() {
        }

        public synchronized NormalCDOLockOwner intern(int sessionID, int viewID) {
            int hashCode = NormalCDOLockOwner.getHashCode(sessionID, viewID);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                NormalCDOLockOwner lockOwner = (NormalCDOLockOwner)entry.get();
                if (lockOwner != null && lockOwner.sessionID == sessionID && lockOwner.viewID == viewID) {
                    return lockOwner;
                }
                entry = entry.getNextEntry();
            }
            NormalCDOLockOwner id = new NormalCDOLockOwner(sessionID, viewID, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(NormalCDOLockOwner lockOwner) {
            return NormalCDOLockOwner.getHashCode(lockOwner.sessionID, lockOwner.viewID);
        }
    }
}

