/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.cdt.internal.ui.viewsupport.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map<ITextEditor, PartListenerGroup> fListenerGroups = new HashMap<ITextEditor, PartListenerGroup>();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener == null) {
                partListener = new PartListenerGroup(part);
                this.fListenerGroups.put(part, partListener);
            }
            partListener.install(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        SelectionListenerWithASTManager selectionListenerWithASTManager = this;
        synchronized (selectionListenerWithASTManager) {
            PartListenerGroup partListener = this.fListenerGroups.get(part);
            if (partListener != null) {
                partListener.uninstall(listener);
                if (partListener.isEmpty()) {
                    this.fListenerGroups.remove(part);
                }
            }
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionListener fPostSelectionListener;
        private ISelectionChangedListener fSelectionListener;
        private Job fCurrentJob;
        private ListenerList<ISelectionListenerWithAST> fAstListeners;
        private final ILock fJobLock = Job.getJobManager().newLock();
        private ISelectionValidator fValidator;

        public PartListenerGroup(ITextEditor editorPart) {
            this.fPart = editorPart;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList(1);
            this.fSelectionListener = event -> {
                ISelection selection = event.getSelection();
                if (selection instanceof ITextSelection) {
                    this.fireSelectionChanged((ITextSelection)selection);
                }
            };
            this.fPostSelectionListener = (part, selection) -> {
                if (part == this.fPart && selection instanceof ITextSelection) {
                    this.firePostSelectionChanged((ITextSelection)selection);
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.addSelectionChangedListener(this.fSelectionListener);
                    if (selectionProvider instanceof ISelectionValidator) {
                        this.fValidator = (ISelectionValidator)selectionProvider;
                    }
                }
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty()) {
                this.fPart.getEditorSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
                ISelectionProvider selectionProvider = this.fPart.getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
                }
                this.fValidator = null;
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(final ITextSelection selection) {
            IWorkingCopy workingCopy;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fPart.getEditorInput())) == null) {
                return;
            }
            this.fCurrentJob = new Job(Messages.SelectionListenerWithASTManager_jobName){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        while (!monitor.isCanceled() && !fJobLock.acquire(10L)) {
                        }
                        if (!monitor.isCanceled() && this.isSelectionValid(selection) && PlatformUI.isWorkbenchRunning()) {
                            IStatus iStatus = this.calculateASTandInform(workingCopy, selection, monitor);
                            return iStatus;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        if (fJobLock.getDepth() != 0) {
                            fJobLock.release();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        protected boolean isSelectionValid(ITextSelection selection) {
            return this.fValidator == null || this.fValidator.isValid((ISelection)selection);
        }

        protected IStatus calculateASTandInform(IWorkingCopy workingCopy, final ITextSelection selection, final IProgressMonitor monitor) {
            return ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_ACTIVE_ONLY, monitor, new ASTCache.ASTRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) {
                    if (astRoot != null && !monitor.isCanceled() && this.isSelectionValid(selection)) {
                        Object[] listeners;
                        PartListenerGroup partListenerGroup = this;
                        synchronized (partListenerGroup) {
                            listeners = fAstListeners.getListeners();
                        }
                        int i = 0;
                        while (i < listeners.length) {
                            Object l = listeners[i];
                            try {
                                ((ISelectionListenerWithAST)l).selectionChanged((IEditorPart)fPart, selection, astRoot);
                            }
                            catch (RuntimeException e) {
                                CUIPlugin.log(e);
                                fAstListeners.remove(l);
                            }
                            catch (OutOfMemoryError e) {
                                CUIPlugin.log(e);
                                fAstListeners.remove(l);
                            }
                            ++i;
                        }
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            });
        }
    }
}

