/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.editor;

import java.text.CharacterIterator;
import org.eclipse.cdt.internal.ui.text.CWordIterator;
import org.eclipse.cdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.cdt.lsp.editor.EditorConfiguration;
import org.eclipse.cdt.lsp.editor.EditorOptions;
import org.eclipse.cdt.lsp.internal.switchtolsp.ISwitchBackToTraditional;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextNavigationAction;

public class CLspEditor
extends ExtensionBasedTextEditor {
    private static final String CONTEXT_ID = "org.eclipse.cdt.lsp.cEditorContext";

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
        action = new DeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = new DeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT_ID});
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        Composite editorComposite = this.createSwitchBackToTraditionalEditorBanner(parent);
        return super.createSourceViewer(editorComposite, ruler, styles);
    }

    private Composite createSwitchBackToTraditionalEditorBanner(Composite parent) {
        Composite editorComposite = (Composite)SafeRunner.run(() -> {
            ISwitchBackToTraditional switchToLsp = (ISwitchBackToTraditional)PlatformUI.getWorkbench().getService(ISwitchBackToTraditional.class);
            if (switchToLsp != null) {
                return switchToLsp.createSwitchBackToTraditional((ITextEditor)this, parent);
            }
            return null;
        });
        if (editorComposite == null) {
            editorComposite = parent;
        }
        return editorComposite;
    }

    private boolean getOptionEnableSubWordNavigation() {
        EditorConfiguration configuration = (EditorConfiguration)PlatformUI.getWorkbench().getService(EditorConfiguration.class);
        if (configuration == null) {
            return false;
        }
        EditorOptions options = null;
        IWorkspace workspace = (IWorkspace)PlatformUI.getWorkbench().getService(IWorkspace.class);
        options = configuration.options(workspace);
        if (options == null) {
            return false;
        }
        return options.enableSubWordNavigation();
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!CLspEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (CLspEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = CLspEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected int findNextPosition(int position) {
            return this.fIterator.following(position);
        }

        public void update() {
            this.setEnabled(CLspEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!CLspEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (CLspEditor.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = CLspEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected int findPreviousPosition(int position) {
            return this.fIterator.preceding(position);
        }

        public void update() {
            this.setEnabled(CLspEditor.this.isEditorInputModifiable());
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(CLspEditor.modelOffset2WidgetOffset((ISourceViewer)CLspEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(CLspEditor.modelOffset2WidgetOffset((ISourceViewer)CLspEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected CWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(CLspEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CWordIterator();
        }

        public void run() {
            if (!CLspEditor.this.getOptionEnableSubWordNavigation()) {
                super.run();
                return;
            }
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText((CharacterIterator)new DocumentCharacterIterator(document));
            int position = CLspEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            try {
                if (CLspEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected CWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(CLspEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CWordIterator();
        }

        public void run() {
            if (!CLspEditor.this.getOptionEnableSubWordNavigation()) {
                super.run();
                return;
            }
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText((CharacterIterator)new DocumentCharacterIterator(document));
            int position = CLspEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            try {
                if (CLspEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = CLspEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = CLspEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

