/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProviders;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.IPropertyExceptionHandler;
import org.eclipse.wb.internal.core.model.property.table.PropertyTableTooltipHelper;
import org.eclipse.wb.internal.core.model.property.table.editparts.PropertyEditPart;
import org.eclipse.wb.internal.core.model.property.table.editparts.PropertyEditPartFactory;
import org.eclipse.wb.internal.core.utils.check.Assert;

public class PropertyTable
extends ScrollingGraphicalViewer {
    public static final String PROP_SPLITTER = "splitter";
    private static final int MIN_COLUMN_WIDTH = 75;
    private static final int MARGIN_RIGHT = 1;
    private static final int MARGIN_BOTTOM = 1;
    private boolean m_showAdvancedProperties;
    private Property[] m_rawProperties;
    private List<PropertyInfo> m_properties;
    private final Set<String> m_expandedIds = new TreeSet<String>();
    private int m_rowHeight;
    private PropertyTableTooltipHelper m_toolTipHelper;
    private PropertyInfo m_activePropertyInfo;
    private String m_activePropertyId;
    private PropertyEditor m_activeEditor;
    private IPropertyExceptionHandler m_exceptionHandler;
    private PropertyCategoryProvider m_propertyCategoryProvider = PropertyCategoryProviders.fromProperty();

    public PropertyTable(Composite parent, int style) {
        this.createControl(parent);
        this.setEditPartFactory(new PropertyEditPartFactory());
        this.setEditDomain(new PropertyEditDomain());
        this.getControl().getViewport().setContentsTracksWidth(true);
        this.getControl().getViewport().setContentsTracksHeight(true);
        this.getControl().addListener(11, event -> this.handleResize());
        this.getControl().setScrollbarsMode(0);
        this.m_rowHeight = 1 + FigureUtilities.getFontMetrics((Font)this.getControl().getFont()).getHeight() + 1;
        this.m_toolTipHelper = new PropertyTableTooltipHelper(this);
        this.setInput(null);
        this.setProperty(PROP_SPLITTER, -1);
    }

    public FigureCanvas getControl() {
        return (FigureCanvas)super.getControl();
    }

    public PropertyEditDomain getEditDomain() {
        return (PropertyEditDomain)super.getEditDomain();
    }

    private void handleResize() {
        int width = this.getSplitter();
        if (width <= 75) {
            width = Math.max((int)((double)this.getControl().getClientArea().width * 0.4), 75);
        }
        this.configureSplitter(width);
    }

    public void activateEditor(Property property, Point location) {
        try {
            this.deactivateEditor(true);
            PropertyEditor editor = property.getEditor();
            try {
                if (editor.activate(this, property, location)) {
                    this.m_activeEditor = editor;
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            this.setActiveEditorBounds();
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public void deactivateEditor(boolean save) {
        if (this.m_activeEditor != null) {
            PropertyEditor activeEditor = this.m_activeEditor;
            this.m_activeEditor = null;
            if (this.m_activePropertyInfo != null && this.m_activePropertyInfo.m_property != null) {
                activeEditor.deactivate(this, this.m_activePropertyInfo.m_property, save);
            }
        }
    }

    private void setActiveEditorBounds() {
        if (this.m_activeEditor != null) {
            int index = this.m_properties.indexOf(this.m_activePropertyInfo);
            if (index == -1) {
                this.deactivateEditor(true);
            } else {
                PropertyEditPart editPart = this.getEditPartForModel(this.m_activePropertyInfo);
                Rectangle figureBounds = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart);
                int x = this.getSplitter() + 1;
                int y = figureBounds.top();
                int width = this.getControl().getClientArea().width - x - 1;
                int height = figureBounds.height() - 1;
                org.eclipse.swt.graphics.Rectangle bounds = new org.eclipse.swt.graphics.Rectangle(x, y, width, height);
                this.m_activeEditor.setBounds(bounds);
            }
        }
    }

    public void setExceptionHandler(IPropertyExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public void handleException(Throwable e) {
        this.m_exceptionHandler.handle(e);
    }

    private static Rectangle getAbsoluteBounds(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private void configureSplitter(int width) {
        int newWidth = width;
        org.eclipse.swt.graphics.Rectangle clientArea = this.getControl().getClientArea();
        if (newWidth < 75) {
            newWidth = 75;
        }
        if (clientArea.width - newWidth < 75) {
            newWidth = clientArea.width - 75;
        }
        this.setProperty(PROP_SPLITTER, newWidth);
    }

    private boolean isLocationSplitter(int x) {
        return Math.abs(this.getSplitter() - x) < 2;
    }

    private boolean isLocationValue(int x) {
        return x > this.getSplitter() + 2;
    }

    private Point getValueRelativeLocation(int x, int y) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.findObjectAt(new Point(x, y));
        return new Point(x - (this.getSplitter() + 2), PropertyTable.getAbsoluteBounds(editPart).top());
    }

    public int getRowHeight() {
        return this.m_rowHeight;
    }

    public void setShowAdvancedProperties(boolean showAdvancedProperties) {
        this.m_showAdvancedProperties = showAdvancedProperties;
        this.setInput0();
    }

    public void setInput(Property[] properties) {
        this.m_rawProperties = properties;
        this.setInput0();
    }

    private void setInput0() {
        if (this.m_rawProperties == null || this.m_rawProperties.length == 0) {
            this.deactivateEditor(false);
            this.m_properties = new ArrayList<PropertyInfo>();
        } else {
            try {
                boolean expanded;
                this.m_properties = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.m_rawProperties;
                int n = this.m_rawProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    Property property = propertyArray[n2];
                    if (this.rawProperties_shouldShow(property)) {
                        PropertyInfo propertyInfo = new PropertyInfo(property);
                        this.m_properties.add(propertyInfo);
                    }
                    ++n2;
                }
                do {
                    expanded = false;
                    ArrayList<PropertyInfo> currentProperties = new ArrayList<PropertyInfo>(this.m_properties);
                    for (PropertyInfo propertyInfo : currentProperties) {
                        expanded |= propertyInfo.expandFromHistory();
                    }
                } while (expanded);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }
        this.setContents(this.m_properties);
        this.getControl().getViewport().validate();
        if (this.m_activePropertyId != null) {
            PropertyInfo newActivePropertyInfo = null;
            if (this.m_properties != null) {
                for (PropertyInfo propertyInfo : this.m_properties) {
                    if (!propertyInfo.m_id.equals(this.m_activePropertyId)) continue;
                    newActivePropertyInfo = propertyInfo;
                    break;
                }
            }
            this.setActivePropertyInfo(newActivePropertyInfo);
        }
    }

    private boolean rawProperties_shouldShow(Property property) throws Exception {
        PropertyCategory category = this.getCategory(property);
        if (category.isHidden()) {
            return false;
        }
        if (category.isAdvanced() && !this.m_showAdvancedProperties && !property.isModified()) {
            return false;
        }
        if (category.isAdvancedReally()) {
            return this.m_showAdvancedProperties;
        }
        return true;
    }

    public void setActiveProperty(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.m_property != property) continue;
            this.setActivePropertyInfo(propertyInfo);
            break;
        }
    }

    public int forTests_getPropertiesCount() {
        return this.m_properties.size();
    }

    public Property forTests_getProperty(int index) {
        return this.m_properties.get(index).getProperty();
    }

    public void forTests_expand(int index) throws Exception {
        this.m_properties.get(index).expand();
    }

    public int getSplitter() {
        return (Integer)this.getProperty(PROP_SPLITTER);
    }

    public org.eclipse.swt.graphics.Point forTests_getStateLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            PropertyEditPart editPart = this.getEditPartForModel(propertyInfo);
            int x = editPart.getTitleX();
            int y = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart).y();
            return new org.eclipse.swt.graphics.Point(x, y);
        }
        return null;
    }

    public org.eclipse.swt.graphics.Point forTests_getValueLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            PropertyEditPart editPart = this.getEditPartForModel(propertyInfo);
            int x = this.getSplitter() + 5;
            int y = PropertyTable.getAbsoluteBounds((GraphicalEditPart)editPart).y();
            return new org.eclipse.swt.graphics.Point(x, y);
        }
        return null;
    }

    public PropertyEditor forTests_getActiveEditor() {
        return this.m_activeEditor;
    }

    private PropertyInfo getPropertyInfo(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.getProperty() != property) continue;
            return propertyInfo;
        }
        return null;
    }

    public final PropertyTableTooltipHelper getTooltipHelper() {
        return this.m_toolTipHelper;
    }

    public void setSelection(ISelection selection) {
        throw new NotImplementedException(PropertyTable.class.getName());
    }

    private void setActivePropertyInfo(PropertyInfo activePropertyInfo) {
        if (activePropertyInfo == null) {
            this.m_activePropertyInfo = null;
            return;
        }
        PropertyEditPart editPart = this.getEditPartForModel(activePropertyInfo);
        if (editPart == null) {
            String msg = NLS.bind((String)ModelMessages.PropertyTable_unknownEditPart, (Object)activePropertyInfo);
            DesignerPlugin.log(Status.warning((String)msg));
            return;
        }
        this.select((EditPart)editPart);
    }

    public final void select(EditPart editPart) {
        this.m_activePropertyInfo = ((PropertyEditPart)editPart).getModel();
        if (this.m_activePropertyInfo != null) {
            this.m_activePropertyId = this.m_activePropertyInfo.m_id;
        }
        this.reveal(editPart);
        super.select(editPart);
    }

    public void setPropertyCategoryProvider(PropertyCategoryProvider propertyCategoryProvider) {
        this.m_propertyCategoryProvider = propertyCategoryProvider;
    }

    public PropertyCategory getCategory(Property property) {
        return this.m_propertyCategoryProvider.getCategory(property);
    }

    public PropertyEditPart getEditPartForModel(PropertyInfo propertyInfo) {
        if (propertyInfo == null) {
            return null;
        }
        return (PropertyEditPart)this.getEditPartForModel(propertyInfo);
    }

    public class PropertyEditDomain
    extends EditDomain {
        private boolean m_splitterResizing;
        private long m_lastExpandCollapseTime;

        public void mouseDown(MouseEvent event, EditPartViewer viewer) {
            EditPart editPart;
            boolean bl = this.m_splitterResizing = event.button == 1 && PropertyTable.this.m_properties != null && PropertyTable.this.isLocationSplitter(event.x);
            if (!this.m_splitterResizing && (editPart = PropertyTable.this.findObjectAt(new Point(event.x, event.y))) instanceof PropertyEditPart) {
                PropertyEditPart editPart2 = (PropertyEditPart)editPart;
                PropertyTable.this.select((EditPart)editPart2);
                Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                PropertyTable.this.deactivateEditor(true);
                PropertyTable.this.getControl().redraw();
                if (PropertyTable.this.isLocationValue(event.x)) {
                    PropertyTable.this.activateEditor(property, PropertyTable.this.getValueRelativeLocation(event.x, event.y));
                }
            }
        }

        public void mouseUp(MouseEvent event, EditPartViewer viewer) {
            if (event.button == 1) {
                if (this.m_splitterResizing) {
                    this.m_splitterResizing = false;
                    return;
                }
                if (!PropertyTable.this.getControl().getClientArea().contains(event.x, event.y)) {
                    return;
                }
                EditPart editPart = PropertyTable.this.findObjectAt(new Point(event.x, event.y));
                if (editPart instanceof PropertyEditPart) {
                    PropertyEditPart editPart2 = (PropertyEditPart)editPart;
                    PropertyInfo propertyInfo = editPart2.getModel();
                    if (editPart2.isLocationState(event.x)) {
                        try {
                            this.m_lastExpandCollapseTime = System.currentTimeMillis();
                            propertyInfo.flip();
                        }
                        catch (Throwable e) {
                            DesignerPlugin.log(e);
                        }
                    }
                }
            }
        }

        public void mouseDoubleClick(MouseEvent event, EditPartViewer viewer) {
            if (System.currentTimeMillis() - this.m_lastExpandCollapseTime > (long)PropertyTable.this.getControl().getDisplay().getDoubleClickTime()) {
                try {
                    if (PropertyTable.this.m_activePropertyInfo != null) {
                        if (PropertyTable.this.m_activePropertyInfo.isComplex()) {
                            PropertyTable.this.m_activePropertyInfo.flip();
                        } else {
                            Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                            property.getEditor().doubleClick(property, PropertyTable.this.getValueRelativeLocation(event.x, event.y));
                        }
                    }
                }
                catch (Throwable e) {
                    PropertyTable.this.handleException(e);
                }
            }
        }

        public void mouseMove(MouseEvent event, EditPartViewer viewer) {
            if (!PropertyTable.this.getControl().getClientArea().contains(event.x, event.y)) {
                return;
            }
            if (PropertyTable.this.findObjectAt(new Point(event.x, event.y)) instanceof PropertyEditPart) {
                if (PropertyTable.this.isLocationSplitter(event.x)) {
                    PropertyTable.this.getControl().setCursor(Cursors.SIZEWE);
                } else {
                    PropertyTable.this.getControl().setCursor(null);
                }
            }
        }

        public void mouseDrag(MouseEvent event, EditPartViewer viewer) {
            if (this.m_splitterResizing) {
                PropertyTable.this.configureSplitter(event.x);
                PropertyTable.this.getControl().redraw();
            }
        }

        public void keyDown(KeyEvent e, EditPartViewer viewer) {
            if (PropertyTable.this.m_activePropertyInfo != null) {
                try {
                    Property property = PropertyTable.this.m_activePropertyInfo.getProperty();
                    if (PropertyTable.this.m_activePropertyInfo.isComplex()) {
                        if (!(PropertyTable.this.m_activePropertyInfo.isExpanded() || e.character != '+' && e.keyCode != 0x1000004)) {
                            PropertyTable.this.m_activePropertyInfo.expand();
                            return;
                        }
                        if (PropertyTable.this.m_activePropertyInfo.isExpanded() && (e.character == '-' || e.keyCode == 0x1000003)) {
                            PropertyTable.this.m_activePropertyInfo.collapse();
                            return;
                        }
                    }
                    if (this.navigate(e)) {
                        return;
                    }
                    if (e.character == ' ' || e.character == '\r') {
                        PropertyTable.this.activateEditor(property, null);
                        return;
                    }
                    if (e.keyCode == 127) {
                        e.doit = false;
                        property.setValue(Property.UNKNOWN_VALUE);
                        return;
                    }
                    property.getEditor().keyDown(PropertyTable.this, property, e);
                }
                catch (Throwable ex) {
                    DesignerPlugin.log(ex);
                }
            }
        }

        public boolean navigate(KeyEvent e) {
            int index = PropertyTable.this.m_properties.indexOf(PropertyTable.this.m_activePropertyInfo);
            int page = PropertyTable.this.getControl().getClientArea().height / PropertyTable.this.m_rowHeight;
            int newIndex = index;
            if (e.keyCode == 0x1000007) {
                newIndex = 0;
            } else if (e.keyCode == 0x1000008) {
                newIndex = PropertyTable.this.m_properties.size() - 1;
            } else if (e.keyCode == 0x1000005) {
                newIndex = Math.max(index - page + 1, 0);
            } else if (e.keyCode == 0x1000006) {
                newIndex = Math.min(index + page - 1, PropertyTable.this.m_properties.size() - 1);
            } else if (e.keyCode == 0x1000001) {
                newIndex = Math.max(index - 1, 0);
            } else if (e.keyCode == 0x1000002) {
                newIndex = Math.min(index + 1, PropertyTable.this.m_properties.size() - 1);
            }
            if (newIndex != index && newIndex < PropertyTable.this.m_properties.size()) {
                PropertyTable.this.setActivePropertyInfo(PropertyTable.this.m_properties.get(newIndex));
                return true;
            }
            return false;
        }
    }

    public final class PropertyInfo {
        private final String m_id;
        private final int m_level;
        private final Property m_property;
        private final boolean m_stateComplex;
        private boolean m_stateExpanded;
        private List<PropertyInfo> m_children;

        public PropertyInfo(Property property) {
            this(property, "", 0);
        }

        private PropertyInfo(Property property, String idPrefix, int level) {
            this.m_id = idPrefix + "|" + property.getTitle();
            this.m_level = level;
            this.m_property = property;
            this.m_stateComplex = property.getEditor() instanceof IComplexPropertyEditor;
        }

        public boolean isComplex() {
            return this.m_stateComplex;
        }

        public boolean isShowComplex() throws Exception {
            if (this.m_stateComplex) {
                this.prepareChildren();
                return !CollectionUtils.isEmpty(this.m_children);
            }
            return false;
        }

        public boolean isExpanded() {
            return this.m_stateExpanded;
        }

        public int getLevel() {
            return this.m_level;
        }

        public Property getProperty() {
            return this.m_property;
        }

        public void flip() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            if (this.m_stateExpanded) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void expand() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(!this.m_stateExpanded);
            this.m_stateExpanded = true;
            PropertyTable.this.m_expandedIds.add(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.addChildren(index + 1);
            PropertyTable.this.setContents(PropertyTable.this.m_properties);
        }

        public void collapse() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(this.m_stateExpanded);
            this.m_stateExpanded = false;
            PropertyTable.this.m_expandedIds.remove(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.removeChildren(index + 1);
            PropertyTable.this.setContents(PropertyTable.this.m_properties);
        }

        private int addChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyTable.this.m_properties.add(index++, child);
                if (!child.isExpanded()) continue;
                index = child.addChildren(index);
            }
            return index;
        }

        private void removeChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyTable.this.m_properties.remove(index);
                if (!child.isExpanded()) continue;
                child.removeChildren(index);
            }
        }

        private void prepareChildren() throws Exception {
            if (this.m_children == null) {
                this.m_children = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.getSubProperties();
                int n = propertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Property subProperty = propertyArray[n2];
                    PropertyInfo subPropertyInfo = this.createSubPropertyInfo(subProperty);
                    this.m_children.add(subPropertyInfo);
                    ++n2;
                }
            }
        }

        private PropertyInfo createSubPropertyInfo(Property subProperty) {
            return new PropertyInfo(subProperty, this.m_id, this.m_level + 1);
        }

        private Property[] getSubProperties() throws Exception {
            IComplexPropertyEditor complexEditor = (IComplexPropertyEditor)((Object)this.m_property.getEditor());
            ArrayList<Property> subProperties = new ArrayList<Property>();
            Property[] propertyArray = complexEditor.getProperties(this.m_property);
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property subProperty = propertyArray[n2];
                if (!PropertyTable.this.getCategory(subProperty).isHidden() || subProperty.isModified()) {
                    subProperties.add(subProperty);
                }
                ++n2;
            }
            return subProperties.toArray(new Property[subProperties.size()]);
        }

        public boolean expandFromHistory() throws Exception {
            if (this.isComplex() && !this.isExpanded() && PropertyTable.this.m_expandedIds.contains(this.m_id)) {
                this.expand();
                return true;
            }
            return false;
        }
    }
}

