/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.data;

import java.util.Collection;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DescriptorTypeVisitor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDescriptorVisitor;

public class DescriptorsInformation {
    private final boolean fAreDescriptorsNumerical;
    private final boolean fAreDescriptorsDuration;
    private final boolean fAreDescriptorsTimestamp;

    public static DescriptorsInformation create(Collection<IDataChartDescriptor<?, ?>> descriptors) {
        DescriptorTypeVisitor visitor = new DescriptorTypeVisitor();
        descriptors.forEach(desc -> desc.accept((IDescriptorVisitor)visitor));
        if (visitor.isEmpty()) {
            throw new IllegalArgumentException("No descriptor were given.");
        }
        if (visitor.isMixed()) {
            throw new IllegalArgumentException("Each descriptor must be the same type.");
        }
        if (visitor.isIndividualType(DescriptorTypeVisitor.DescriptorType.NUMERICAL)) {
            if (visitor.isIndividualType(DescriptorTypeVisitor.DescriptorType.DURATION)) {
                return new DescriptorsInformation(true, true, false);
            }
            if (visitor.isIndividualType(DescriptorTypeVisitor.DescriptorType.TIMESTAMP)) {
                return new DescriptorsInformation(true, false, true);
            }
            return new DescriptorsInformation(true, false, false);
        }
        return new DescriptorsInformation(false, false, false);
    }

    private DescriptorsInformation(boolean numerical, boolean durations, boolean timestamps) {
        this.fAreDescriptorsNumerical = numerical;
        this.fAreDescriptorsDuration = durations;
        this.fAreDescriptorsTimestamp = timestamps;
    }

    public boolean areNumerical() {
        return this.fAreDescriptorsNumerical;
    }

    public boolean areDuration() {
        return this.fAreDescriptorsDuration;
    }

    public boolean areTimestamp() {
        return this.fAreDescriptorsTimestamp;
    }
}

