/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTiCompilerChain;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.MainTab;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Group;

public class QVTiMainTab
extends MainTab<Transformation>
implements QVTiLaunchConstants {
    protected @NonNull QVTiCompilerChain createCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull CompilerOptions compilerOptions) {
        return new QVTiCompilerChain(environmentFactory, txURI, txURI, compilerOptions);
    }

    @Override
    protected void createDirectionGroup(Group txGroup) {
    }

    @Override
    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTiModelFile.gif");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull String> getIntermediateKeys() {
        @NonNull ArrayList asList = Lists.newArrayList((Object[])QVTiLaunchConfigurationDelegate.compileStepKeys);
        if (!this.isInterpreted()) {
            String[] stringArray = QVTiLaunchConfigurationDelegate.generateStepKeys;
            int n = QVTiLaunchConfigurationDelegate.generateStepKeys.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String stepKey = stringArray[n2];
                asList.add(stepKey);
                ++n2;
            }
        }
        return asList;
    }

    @Override
    protected void initializeOptions(@NonNull DefaultCompilerOptions compilerOptions) throws IOException {
        compilerOptions.setOption("default", CompilerChain.SAVE_OPTIONS_KEY, (Object)XMIUtil.createSaveOptions());
        if (this.isInterpreted()) {
            compilerOptions.setOption("Java", CompilerChain.URI_KEY, null);
            compilerOptions.setOption("Class", CompilerChain.URI_KEY, null);
        } else {
            this.initializeURIOption((CompilerOptions)compilerOptions, "Java");
            this.initializeURIOption((CompilerOptions)compilerOptions, "Class");
        }
        this.initializeURIOption((CompilerOptions)compilerOptions, "QVTi");
    }

    @Override
    protected void updateDirection(@NonNull Transformation tansformation) {
    }

    @Override
    protected void updateGroups(@NonNull Transformation transformation, @NonNull Map<@NonNull String, @Nullable String> oldInputsMap, @NonNull Map<@NonNull String, @Nullable String> newInputsMap, @NonNull Map<@NonNull String, @Nullable String> oldOutputsMap, @NonNull Map<@NonNull String, @Nullable String> newOutputsMap, @NonNull Map<@NonNull String, @Nullable String> intermediateMap) {
        super.updateGroups(transformation, oldInputsMap, newInputsMap, oldOutputsMap, newOutputsMap, intermediateMap);
        for (TypedModel typedModel : QVTimperativeUtil.getModelParameters((Transformation)transformation)) {
            String name;
            if (QVTimperativeUtil.isInput((TypedModel)typedModel)) {
                name = typedModel.getName();
                assert (name != null);
                newInputsMap.put(name, null);
            }
            if (!QVTimperativeUtil.isOutput((TypedModel)typedModel)) continue;
            name = typedModel.getName();
            assert (name != null);
            newOutputsMap.put(name, null);
        }
        for (String key : newOutputsMap.keySet()) {
            newInputsMap.remove(key);
        }
    }

    @Override
    protected @NonNull Transformation updateTransformation(@NonNull URI txURI) throws IOException {
        QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
        return QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)txURI, (boolean)environmentFactory.keepDebug());
    }
}

