/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsManager;

public class ExpressionsUtil {
    private static final String CHECK_CLASS_METHOD_EXISTS = "eval(''if (class_exists(\\''ReflectionClass\\'')) return (new ReflectionClass({0}))->hasMethod(\\''{1}\\''); else return false;'');";
    private static final int PROP_MOD_PUBLIC = 256;
    private static final int PROP_MOD_PROTECTED = 512;
    private static final int PROP_MOD_PRIVATE = 1024;
    private static final Map<Expression, String> staticMemberClassNames = new WeakHashMap<Expression, String>();
    private static Map<ExpressionsManager, ExpressionsUtil> fInstance = new WeakHashMap<ExpressionsManager, ExpressionsUtil>();
    private ExpressionsManager fExpressionsManager;

    private ExpressionsUtil(ExpressionsManager expressionsManager) {
        this.fExpressionsManager = expressionsManager;
    }

    public static ExpressionsUtil getInstance(ExpressionsManager expressionsManager) {
        if (fInstance.get(expressionsManager) == null) {
            fInstance.put(expressionsManager, new ExpressionsUtil(expressionsManager));
        }
        return fInstance.get(expressionsManager);
    }

    public Expression[] fetchStaticMembers(String className) {
        FetchStaticsExpression staticMembers = new FetchStaticsExpression(className);
        this.fExpressionsManager.update(staticMembers, 1);
        Expression[] members = staticMembers.getValue().getChildren();
        if (members == null) {
            return new Expression[0];
        }
        int[] mods = this.fetchStaticMembersVisibility(className, members);
        if (mods == null) {
            return new Expression[0];
        }
        if (members.length > 0) {
            int i = 0;
            while (i < members.length) {
                Expression member = members[i];
                staticMemberClassNames.put(member, className);
                if ((mods[i] & 0x400) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PRIVATE);
                } else if ((mods[i] & 0x200) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PROTECTED);
                } else if ((mods[i] & 0x100) > 0) {
                    member.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
                }
                ++i;
            }
            return members;
        }
        return new Expression[0];
    }

    public Expression[] fetchClassConstants(String className) {
        FetchClassConstantsExpression constants = new FetchClassConstantsExpression(className);
        this.fExpressionsManager.update(constants, 1);
        Expression[] members = constants.getValue().getChildren();
        if (members == null) {
            return new Expression[0];
        }
        Expression[] expressionArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
            ++n2;
        }
        return members;
    }

    public Expression fetchConstant(String constantName) {
        FetchConstantExpression constant = new FetchConstantExpression(constantName);
        this.fExpressionsManager.update(constant, 1);
        DefaultExpression newExpression = new DefaultExpression(constantName, IVariableFacet.Facet.KIND_CONSTANT, IVariableFacet.Facet.MOD_PUBLIC);
        newExpression.setValue(constant.getValue());
        return newExpression;
    }

    private boolean invokeMethod(String object, String method, StringBuilder result) {
        DefaultExpression e = new DefaultExpression(MessageFormat.format(CHECK_CLASS_METHOD_EXISTS, object, method));
        this.fExpressionsManager.update(e, 1);
        if (e.getValue().getValue() != null && e.getValue().getValue().equals("1")) {
            String expression = object + "->" + method + "()";
            e = new DefaultExpression(expression);
            this.fExpressionsManager.getExpressionValue(e, 1);
            this.fExpressionsManager.update(e, 1);
            result.append(e.getValue().getValue());
            return true;
        }
        return false;
    }

    public static String fetchStaticMemberClassName(Expression staticMember) {
        return staticMemberClassNames.get(staticMember);
    }

    public Expression fetchStaticContext(String className) {
        Expression[] staticMembers = this.fetchStaticMembers(className);
        if (staticMembers.length == 0) {
            return null;
        }
        DefaultExpression classStaticContext = new DefaultExpression("<class>", IVariableFacet.Facet.VIRTUAL_CLASS);
        ExpressionValue classStaticContextValue = new ExpressionValue(IPHPDataType.DataType.PHP_VIRTUAL_CLASS, className, "Class of: " + className, staticMembers, staticMembers.length);
        classStaticContext.setValue(classStaticContextValue);
        return classStaticContext;
    }

    private int[] fetchStaticMembersVisibility(String className, Expression[] members) {
        StringBuilder tuple = new StringBuilder();
        int i = 0;
        while (i < members.length) {
            tuple.append(MessageFormat.format("(new ReflectionProperty(\\''{0}\\'', \\''{1}\\''))->getModifiers()", className, members[i].getLastName()));
            if (i < members.length - 1) {
                tuple.append(',');
            }
            ++i;
        }
        FetchStaticsVisibilityExpression fetchModifiersExpression = new FetchStaticsVisibilityExpression(tuple.toString());
        this.fExpressionsManager.update(fetchModifiersExpression, 1);
        Expression[] computed = fetchModifiersExpression.getValue().getOriChildren();
        if (computed == null) {
            return null;
        }
        int[] mods = new int[computed.length];
        int i2 = 0;
        while (i2 < computed.length) {
            mods[i2] = Integer.valueOf((String)computed[i2].getValue().getValue());
            ++i2;
        }
        return mods;
    }

    public Expression fetchClassContext(String className) {
        DefaultExpression classContext = new DefaultExpression("<class>", IVariableFacet.Facet.VIRTUAL_CLASS);
        ExpressionValue classStaticContextValue = new ExpressionValue(IPHPDataType.DataType.PHP_VIRTUAL_CLASS, className, className, null);
        classContext.setValue(classStaticContextValue);
        return classContext;
    }

    public String getValueDetail(Expression expression) {
        ExpressionValue value = expression.getValue();
        if (value.getDataType() == IPHPDataType.DataType.PHP_OBJECT) {
            StringBuilder result = new StringBuilder();
            boolean exists = this.invokeMethod(expression.getFullName(), "__toString", result);
            if (exists) {
                return result.toString();
            }
        } else {
            if (value.getDataType() == IPHPDataType.DataType.PHP_ARRAY) {
                this.fExpressionsManager.update(expression, 1);
                StringBuilder result = new StringBuilder("[");
                int i = 0;
                while (i < expression.getValue().getChildren().length) {
                    Expression child = expression.getValue().getChildren()[i];
                    if (i > 0) {
                        result.append(",");
                        result.append(" ");
                    }
                    result.append(child.getLastName());
                    result.append(" => ");
                    result.append(this.getValueDetail(child));
                    ++i;
                }
                result.append("]");
                return result.toString();
            }
            if (value.getDataType() == IPHPDataType.DataType.PHP_STRING) {
                String result = expression.getValue().getValueAsString();
                int length = result.length();
                return result.substring(1, length - 1);
            }
        }
        return expression.getValue().getValueAsString();
    }

    public Expression buildExpression(String variable) {
        Expression expression = this.fExpressionsManager.buildExpression(variable);
        this.fExpressionsManager.getExpressionValue(expression, 1);
        this.fExpressionsManager.update(expression, 1);
        return expression;
    }

    private static final class FetchClassConstantsExpression
    extends DefaultExpression {
        static final String FETCH_CONSTANTS = "eval(''if (class_exists(\\''ReflectionClass\\'') && class_exists(\\''{0}\\'')) return (new ReflectionClass(\\''{0}\\''))->getConstants(); else return array();'');";

        public FetchClassConstantsExpression(String className) {
            super(MessageFormat.format(FETCH_CONSTANTS, className), className);
        }

        @Override
        public Expression createChildExpression(String endName, String endRepresentation, IVariableFacet.Facet ... facets) {
            return new DefaultExpression(this, endName, "::" + endName, IVariableFacet.Facet.KIND_CONSTANT);
        }
    }

    private static final class FetchConstantExpression
    extends DefaultExpression {
        static final String FETCH_CONSTANT = "eval(''return constant(\\''{0}\\'');'');";

        public FetchConstantExpression(String constantName) {
            super(MessageFormat.format(FETCH_CONSTANT, constantName), constantName);
        }
    }

    private static final class FetchStaticsExpression
    extends DefaultExpression {
        static final String FETCH_STATIC_MEMBERS = "eval(''if (class_exists(\\''ReflectionClass\\'') && class_exists(\\''{0}\\'')) return (new ReflectionClass(\\''{0}\\''))->getStaticProperties(); else return array();'');";

        public FetchStaticsExpression(String className) {
            super(MessageFormat.format(FETCH_STATIC_MEMBERS, className), className);
        }

        @Override
        public Expression createChildExpression(String endName, String endRepresentation, IVariableFacet.Facet ... facets) {
            return new DefaultExpression(this, endName, "::$" + endName, IVariableFacet.Facet.KIND_OBJECT_MEMBER, IVariableFacet.Facet.MOD_STATIC);
        }
    }

    private static final class FetchStaticsVisibilityExpression
    extends DefaultExpression {
        static final String FETCH_STATICS_MODIFIERS = "eval(''if (class_exists(\\''ReflectionProperty\\'')) return array({0}); else return array();'');";
        static final String TUPLE_ELEMENT = "(new ReflectionProperty(\\''{0}\\'', \\''{1}\\''))->getModifiers()";

        public FetchStaticsVisibilityExpression(String tuple) {
            super(MessageFormat.format(FETCH_STATICS_MODIFIERS, tuple));
        }
    }
}

