/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.profiles;

/**
 * Root element of the profiles.xml file.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ProfilesRoot
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field profiles.
     */
    private java.util.List<Profile> profiles;

    /**
     * Field activeProfiles.
     */
    private java.util.List<String> activeProfiles;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addActiveProfile.
     * 
     * @param string a string object.
     */
    public void addActiveProfile( String string )
    {
        getActiveProfiles().add( string );
    } //-- void addActiveProfile( String )

    /**
     * Method addProfile.
     * 
     * @param profile a profile object.
     */
    public void addProfile( Profile profile )
    {
        getProfiles().add( profile );
    } //-- void addProfile( Profile )

    /**
     * Method getActiveProfiles.
     * 
     * @return List
     */
    public java.util.List<String> getActiveProfiles()
    {
        if ( this.activeProfiles == null )
        {
            this.activeProfiles = new java.util.ArrayList<String>();
        }

        return this.activeProfiles;
    } //-- java.util.List<String> getActiveProfiles()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method getProfiles.
     * 
     * @return List
     */
    public java.util.List<Profile> getProfiles()
    {
        if ( this.profiles == null )
        {
            this.profiles = new java.util.ArrayList<Profile>();
        }

        return this.profiles;
    } //-- java.util.List<Profile> getProfiles()

    /**
     * Method removeActiveProfile.
     * 
     * @param string a string object.
     */
    public void removeActiveProfile( String string )
    {
        getActiveProfiles().remove( string );
    } //-- void removeActiveProfile( String )

    /**
     * Method removeProfile.
     * 
     * @param profile a profile object.
     */
    public void removeProfile( Profile profile )
    {
        getProfiles().remove( profile );
    } //-- void removeProfile( Profile )

    /**
     * Set list of manually-activated build profiles, specified in
     * the order in which
     *             they should be applied.
     * 
     * @param activeProfiles a activeProfiles object.
     */
    public void setActiveProfiles( java.util.List<String> activeProfiles )
    {
        this.activeProfiles = activeProfiles;
    } //-- void setActiveProfiles( java.util.List )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding a modelEncoding object.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set configuration of build profiles for adjusting the build
     *             according to environmental parameters.
     * 
     * @param profiles a profiles object.
     */
    public void setProfiles( java.util.List<Profile> profiles )
    {
        this.profiles = profiles;
    } //-- void setProfiles( java.util.List )

}
