/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.BaseCodeActionRequest;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class CodeActionRequest
extends BaseCodeActionRequest
implements ICodeActionRequest {
    private final Diagnostic diagnostic;
    private final Range range;
    private XMLGenerator generator;
    private LineIndentInfo indentInfo;

    public CodeActionRequest(Diagnostic diagnostic, Range range, DOMDocument document, IComponentProvider componentProvider, SharedSettings sharedSettings) {
        super(document, componentProvider, sharedSettings);
        this.diagnostic = diagnostic;
        this.range = range;
    }

    @Override
    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public XMLGenerator getXMLGenerator() throws BadLocationException {
        if (this.generator == null) {
            this.generator = new XMLGenerator(this.getSharedSettings(), this.getSharedSettings().getCompletionSettings().isAutoCloseTags(), this.getLineIndentInfo().getWhitespacesIndent(), this.getLineIndentInfo().getLineDelimiter(), false, Integer.MAX_VALUE, null);
        }
        return this.generator;
    }

    public LineIndentInfo getLineIndentInfo() throws BadLocationException {
        if (this.indentInfo == null) {
            int lineNumber = this.getRange().getStart().getLine();
            this.indentInfo = this.getDocument().getLineIndentInfo(lineNumber);
        }
        return this.indentInfo;
    }
}

