/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.ui.view;

import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.RemoveAllVisibleFinishedResultAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.RemoveResultAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.SaveResultInstanceAction;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.TerminateInstanceAction;
import org.eclipse.datatools.sqltools.result.internal.ui.filters.OpenFilterDialogAction;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.PreferenceUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistorySection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSectionFactory;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleTabDisplayAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.TextModeDisplayAction;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ResultsViewControl
implements IPropertyChangeListener,
IProfileListener1,
IContextProvider,
IResultManagerListener {
    private ResultsView _resultsView;
    private SashForm _sashform;
    private Composite _leftArea;
    private Composite _detailArea;
    private ResultSection _resultSection;
    private IResultInstance _currentInstance = null;
    private Action _preferenceAction = null;
    private IMemento _memento;
    private IPreferenceStore _store;
    private Display _display;
    private ResultHistorySection _resultHistory;
    private RemoveResultAction _removeResultAction;
    private RemoveAllVisibleFinishedResultAction _removeAllVisibleFinishedResultAction;
    private TerminateInstanceAction _terminateAction;
    private SaveResultInstanceAction _saveResultInstanceAction;
    private VerticalLayoutAction _vLayoutAction;
    private HorizontalLayoutAction _hLayoutAction;
    private OpenFilterDialogAction _openFilterDialogAction;
    private boolean _usePreferences = true;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName());
    SingleTabDisplayAction _singleTabDisplayAction = null;
    TextModeDisplayAction _textModeDisplayAction = null;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public ResultsViewControl() {
        this(null);
    }

    public ResultsViewControl(ResultsView resultsView) {
        this._resultsView = resultsView;
    }

    public void init() throws PartInitException {
        this.init(null, null);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this._memento = memento;
        this._store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        this._store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void saveState(IMemento memento) {
        this._resultHistory.saveState(memento);
    }

    public Composite getControl() {
        return this._sashform;
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HelpUtil.getContextId((String)"view_sql_result", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
        this._sashform = new SashForm(parent, PreferenceUtil.getBoolean(ResultsViewUIPlugin.getDefault().getPreferenceStore(), PreferenceConstants.VERTICAL_LAYOUT_RESULTS_VIEW, this.getUsePreferences()) ? 512 : 65792);
        this._display = this._sashform.getDisplay();
        this._leftArea = new Composite((Composite)this._sashform, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this._leftArea.setLayout((Layout)layout);
        this._leftArea.layout(true);
        this._detailArea = new Composite((Composite)this._sashform, 0);
        this._detailArea.setLayout((Layout)new FillLayout());
        this._resultSection = ResultSectionFactory.createResultSection(this._detailArea, this);
        this._resultHistory = new ResultHistorySection(this._leftArea, this._detailArea, this);
        this._resultHistory.applyState(this._memento);
        this.createActions();
        ProfileManager pMgr = ProfileManager.getInstance();
        pMgr.addProfileListener((IProfileListener)this);
    }

    public void createActions() {
        this._textModeDisplayAction = new TextModeDisplayAction();
        this._textModeDisplayAction.update();
        this._singleTabDisplayAction = new SingleTabDisplayAction();
        this._singleTabDisplayAction.update();
        this._terminateAction = new TerminateInstanceAction((ISelectionProvider)this._resultHistory.getResultTable());
        this._terminateAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.terminate");
        this._saveResultInstanceAction = new SaveResultInstanceAction(this._resultHistory.getResultTable().getTree().getShell(), (ISelectionProvider)this._resultHistory.getResultTable());
        this._removeResultAction = new RemoveResultAction((ISelectionProvider)this._resultHistory.getResultTable());
        this._removeResultAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.removeInstance");
        this._removeAllVisibleFinishedResultAction = new RemoveAllVisibleFinishedResultAction((ISelectionProvider)this._resultHistory.getResultTable(), null);
        this._removeAllVisibleFinishedResultAction.setActionDefinitionId("org.eclipse.datatools.sqltools.result.removeAllInstances");
        this._preferenceAction = new Action(Messages.ResultsView_preference){

            public void run() {
                String[] preferencePages = new String[]{"org.eclipse.datatools.sqltools.result.displayOption", "org.eclipse.datatools.sqltools.result.resultHistory", "org.eclipse.datatools.sqltools.result.exportFormat", "org.eclipse.datatools.sqltools.result.resultSetViewerPreference"};
                PreferencesUtil.createPreferenceDialogOn(null, (String)preferencePages[0], (String[])preferencePages, null).open();
            }
        };
        this._vLayoutAction = new VerticalLayoutAction(this._sashform);
        this._hLayoutAction = new HorizontalLayoutAction(this._sashform);
        this._openFilterDialogAction = new OpenFilterDialogAction(this._resultHistory.getResultTable().getTree().getShell());
    }

    public void setFocus() {
        if (this._sashform != null && !this._sashform.isDisposed()) {
            this._sashform.setFocus();
        }
    }

    public void dispose() {
        this._terminateAction.dispose();
        this._removeResultAction.dispose();
        this._store.removePropertyChangeListener((IPropertyChangeListener)this);
        ProfileManager pMgr = ProfileManager.getInstance();
        pMgr.removeProfileListener((IProfileListener)this);
        this._resultHistory.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getUsePreferences()) {
            if (event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_NUMBER) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_HEADING) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_SHOW_ROW_COUNT_MSG) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_SPLIT_MESSAGES) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_TABS_NUMBER) || event.getProperty().equals(PreferenceConstants.SQL_RESULTS_VIEW_TABLES_LIMITATION)) {
                this._singleTabDisplayAction.update();
                this._textModeDisplayAction.update();
                ISelection selection = this._resultHistory.getSelection();
                IStructuredSelection sSelection = null;
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                sSelection = (IStructuredSelection)selection;
                IResultInstance instance = (IResultInstance)sSelection.getFirstElement();
                this.reDisplay(instance);
            }
            if (event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_LIMIT_CHECK) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_LIMIT_NUM) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_STATUS_CRITICAL) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_STATUS_WARNING) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_STATUS_FAILED) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_STATUS_SUCCESS) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_STATUS_TERMINATED) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_UNKNOWNPROFILE) || event.getProperty().equals(PreferenceConstants.PROFILE_FILTERS_PROFILE_MAY_CHANGED)) {
                this._resultHistory.getResultTable().refresh();
            }
            if (event.getProperty().equals(PreferenceConstants.RESULT_HISTORY_ALL_COLUMNS)) {
                this._resultHistory.reDisplayResults();
            }
        }
    }

    public void reDisplay(final IResultInstance instance) {
        if (instance != null) {
            BusyIndicator.showWhile((Display)this._display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ResultsViewControl.this._display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Composite comp;
                            if (ResultsViewControl.this._resultSection != null && (comp = ResultsViewControl.this._resultSection.getControl()) != null && !comp.isDisposed()) {
                                comp.dispose();
                            }
                            ResultsViewControl.this._resultSection = ResultSectionFactory.createResultSection(ResultsViewControl.this._detailArea, ResultsViewControl.this);
                            ResultsViewControl.this._detailArea.layout(true);
                            ResultsViewControl.this._resultSection.showDetail(instance);
                            ResultsViewControl.this._resultHistory.refresh();
                        }
                    });
                }
            });
        } else {
            this._display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Composite comp;
                    if (ResultsViewControl.this._resultSection != null && (comp = ResultsViewControl.this._resultSection.getControl()) != null && !comp.isDisposed()) {
                        comp.dispose();
                    }
                    ResultsViewControl.this._resultSection = ResultSectionFactory.createResultSection(ResultsViewControl.this._detailArea, ResultsViewControl.this);
                    ResultsViewControl.this._detailArea.layout(true);
                }
            });
        }
    }

    public ResultSection getResultSection() {
        return this._resultSection;
    }

    public void setResultSection(ResultSection section) {
        this._resultSection = section;
    }

    public ResultHistorySection getResultHistorySection() {
        return this._resultHistory;
    }

    public IResultInstance getCurrentInstance() {
        return this._currentInstance;
    }

    public IAction[] getRegisteredActions() {
        return new IAction[]{this._removeResultAction, this._removeAllVisibleFinishedResultAction, this._terminateAction, this._saveResultInstanceAction};
    }

    public void refreshResults() {
        this._resultHistory.getResultTable().refresh();
    }

    public void setCurrentInstance(IResultInstance instance) {
        this._currentInstance = instance;
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileAdded(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileDeleted(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public void profileChanged(IConnectionProfile profile) {
        this._sashform.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.getResultTable().refresh();
            }
        });
    }

    public RemoveAllVisibleFinishedResultAction getRemoveAllVisibleFinishedResultAction() {
        return this._removeAllVisibleFinishedResultAction;
    }

    public void clearHistory() {
        this._removeAllVisibleFinishedResultAction.setInstances(ResultsViewUIPlugin.getResultManager().getAllResults());
        this._removeAllVisibleFinishedResultAction.run();
    }

    public ResultsView getView() {
        return this._resultsView;
    }

    public void addResultHistoryFilter(ViewerFilter filter) {
        this.getResultHistorySection().getResultTable().addFilter(filter);
    }

    public boolean getUsePreferences() {
        return this._usePreferences;
    }

    public void setUsePreferences(boolean usePreferences) {
        this._usePreferences = usePreferences;
    }

    public IAction getTerminateAction() {
        return this._terminateAction;
    }

    public IAction getRemoveResultAction() {
        return this._removeResultAction;
    }

    public IAction getSingleTabDisplayAction() {
        return this._singleTabDisplayAction;
    }

    public IAction getTextModeDisplayAction() {
        return this._textModeDisplayAction;
    }

    public Action getVLayoutAction() {
        return this._vLayoutAction;
    }

    public Action getHLayoutAction() {
        return this._hLayoutAction;
    }

    public IAction getOpenFilterDialogAction() {
        return this._openFilterDialogAction;
    }

    public IAction getPreferenceAction() {
        return this._preferenceAction;
    }

    public void resultInstanceCreated(final IResultInstance result) {
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (ResultsViewControl.this._resultsView != null) {
                    ResultsViewControl.this._resultsView.clearStatusLine();
                }
                ResultsViewControl.this._resultHistory.search();
                ResultsViewControl.this._resultHistory.refresh();
                ResultsViewControl.this._resultHistory.getResultTable().setSelection((ISelection)new StructuredSelection((Object)result));
                ResultsViewControl.this._currentInstance = result;
            }
        });
    }

    public void resultInstanceRemoved(IResultInstance result) {
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (ResultsViewControl.this._resultsView != null) {
                    ResultsViewControl.this._resultsView.clearStatusLine();
                }
                ResultsViewControl.this._resultHistory.search();
                ResultsViewControl.this._resultHistory.refresh();
            }
        });
    }

    public void resultInstancesRemoved(IResultInstance[] results) {
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (ResultsViewControl.this._resultsView != null) {
                    ResultsViewControl.this._resultsView.clearStatusLine();
                }
                ResultsViewControl.this._resultHistory.search();
                ResultsViewControl.this._resultHistory.refresh();
            }
        });
    }

    public void allResultInstancesRemoved() {
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (ResultsViewControl.this._resultsView != null) {
                    ResultsViewControl.this._resultsView.clearStatusLine();
                }
                ResultsViewControl.this._resultHistory.search();
                ResultsViewControl.this._resultHistory.refresh();
            }
        });
    }

    public void resultInstanceAppended(IResultInstance instance, final ResultItem result, final int index) {
        if (instance != this._currentInstance) {
            return;
        }
        this._sashform.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultSection.onNewItemAppended(result, index);
            }
        });
    }

    public void resultInstanceStatusUpdated(final IResultInstance instance) {
        if (instance.isFinished()) {
            this._terminateAction.update();
            this._removeResultAction.update();
        }
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.refresh();
                if (instance == ResultsViewControl.this._currentInstance && instance.isFinished()) {
                    ResultsViewControl.this._resultHistory.search();
                    ResultsViewControl.this._resultHistory.refresh();
                    ResultsViewControl.this._resultSection.onInstanceFinished();
                }
            }
        });
    }

    public void resultInstanceReset(final IResultInstance instance) {
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultHistory.search();
                ResultsViewControl.this._resultHistory.refresh();
                if (instance == ResultsViewControl.this._currentInstance) {
                    ResultsViewControl.this._resultSection.onInstanceReseted();
                }
            }
        });
    }

    public void parametersShow(IResultInstance instance, final List params) {
        if (instance != this._currentInstance) {
            return;
        }
        this._display.syncExec(new Runnable(){

            @Override
            public void run() {
                ResultsViewControl.this._resultSection.onParametersShown(params);
            }
        });
    }

    class HorizontalLayoutAction
    extends Action {
        SashForm _sash;

        public HorizontalLayoutAction(SashForm sash) {
            super(Messages.ResultsView_layout_horizontal, 8);
            this._sash = sash;
        }

        public void run() {
            this._sash.setOrientation(256);
            ResultsViewUIPlugin.getDefault().getPreferenceStore().setValue(PreferenceConstants.VERTICAL_LAYOUT_RESULTS_VIEW, false);
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.DESC_HORIZONTAL_RESULTS_VIEW;
        }
    }

    class VerticalLayoutAction
    extends Action {
        SashForm _sash;

        public VerticalLayoutAction(SashForm sash) {
            super(Messages.ResultsView_layout_vertical, 8);
            this._sash = sash;
        }

        public void run() {
            this._sash.setOrientation(512);
            ResultsViewUIPlugin.getDefault().getPreferenceStore().setValue(PreferenceConstants.VERTICAL_LAYOUT_RESULTS_VIEW, true);
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.DESC_VERTICAL_RESULTS_VIEW;
        }
    }
}

