/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

class ColumnInfo {
    private static final String EMPTY_STRING = "";
    private int index;
    private String name;
    private String type;
    private String path;
    private String originalPath;
    private HashMap filters;

    public ColumnInfo(int index, String name, String type, String originalPath, HashMap filters) throws OdaException {
        this.index = index;
        this.name = name;
        this.type = type;
        if (!DataTypes.isValidType(type)) {
            throw new OdaException(Messages.getString("RelationInformation.InvalidDataTypeName"));
        }
        this.originalPath = originalPath;
        String purePath = originalPath.replaceAll("\\Q[@\\E.*\\Q=\\E.*?\\Q]\\E", EMPTY_STRING).replaceAll("\\Q[@\\E.*\\Q]\\E", EMPTY_STRING).trim();
        this.path = SaxParserUtil.removeRedundantParentAxis(purePath);
        this.filters = filters;
    }

    public String getColumnName() {
        return this.name;
    }

    public String getColumnType() {
        return this.type;
    }

    public String getColumnOriginalPath() {
        return this.originalPath;
    }

    public String getColumnPath() {
        return this.path;
    }

    public int getColumnIndex() {
        return this.index;
    }

    public HashMap getFilters() {
        return this.filters;
    }
}

