/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.burningwave.core.Closeable;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHelperImpl;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.ByteBufferOutputStream;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;

public class JavaMemoryCompilerImpl
implements JavaMemoryCompiler,
Component {
    PathHelper pathHelper;
    ClassPathHelper classPathHelper;
    JavaCompiler compiler;
    FileSystemItem compiledClassesRepository;
    Map<?, ?> config;

    JavaMemoryCompilerImpl(PathHelper pathHelper, ClassPathHelper classPathHelper, Map<?, ?> config) {
        this.pathHelper = pathHelper;
        this.classPathHelper = classPathHelper;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.compiledClassesRepository = FileSystemItem.of(((ClassPathHelperImpl)classPathHelper).getOrCreateTemporaryFolder("compiledClassesRepository"));
        this.config = config;
    }

    @Override
    public QueuedTaskExecutor.ProducerTask<JavaMemoryCompiler.Compilation.Result> compile(JavaMemoryCompiler.Compilation.Config config) {
        return this.compile(config.getSources(), this.getClassPathsFrom(config), this.getClassRepositoriesFrom(config), this.getBlackListedClassPaths(config), config.getCompiledClassesStorage(), config.useTemporaryFolderForStoring(), config.getExtraParameters());
    }

    private Collection<String> getBlackListedClassPaths(JavaMemoryCompiler.Compilation.Config config) {
        return StaticComponentContainer.IterableObjectHelper.merge(config::getBlackListedClassPaths, config::getAdditionalBlackListedClassPaths, () -> {
            Collection<String> blackListedClassPaths = this.pathHelper.getPaths(JavaMemoryCompiler.Configuration.Key.BLACK_LISTED_CLASS_PATHS);
            return blackListedClassPaths;
        });
    }

    Collection<String> getClassRepositoriesFrom(JavaMemoryCompiler.Compilation.Config config) {
        return StaticComponentContainer.IterableObjectHelper.merge(config::getClassRepositories, config::getAdditionalClassRepositories, () -> {
            Collection<String> classRepositories = this.pathHelper.getPaths(JavaMemoryCompiler.Configuration.Key.CLASS_REPOSITORIES);
            return classRepositories;
        });
    }

    Collection<String> getClassPathsFrom(JavaMemoryCompiler.Compilation.Config config) {
        return StaticComponentContainer.IterableObjectHelper.merge(config::getClassPaths, config::getAdditionalClassPaths, () -> this.pathHelper.getPaths(JavaMemoryCompiler.Configuration.Key.CLASS_PATHS));
    }

    private QueuedTaskExecutor.ProducerTask<JavaMemoryCompiler.Compilation.Result> compile(Collection<String> sources, Collection<String> classPaths, Collection<String> classRepositoriesPaths, Collection<String> blackListedClassPaths, String compiledClassesStorage, boolean useTemporaryFolderForStoring, Map<String, String> extraOptions) {
        QueuedTaskExecutor.ProducerTask<JavaMemoryCompiler.Compilation.Result> tsk = StaticComponentContainer.BackgroundExecutor.createProducerTask(task -> {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "Try to compile: \n\n{}\n", String.join((CharSequence)"\n", StaticComponentContainer.SourceCodeHandler.addLineCounter(sources)));
            ArrayList<MemorySource> memorySources = new ArrayList<MemorySource>();
            this.sourcesToMemorySources(sources, memorySources);
            try (Compilation.Context context = Compilation.Context.create(this, memorySources, new ArrayList<String>(classPaths), new ArrayList<String>(classRepositoriesPaths), new ArrayList<String>(blackListedClassPaths), extraOptions);){
                Map<String, ByteBuffer> compiledFiles = this.compile(context);
                String storedFilesClassPath = this.retrieveCompiledClassesStorage(compiledClassesStorage, useTemporaryFolderForStoring);
                if (!compiledFiles.isEmpty() && compiledClassesStorage != null) {
                    compiledFiles.forEach((className, byteCode) -> JavaClass.use(byteCode, javaClass -> javaClass.storeToClassPath(storedFilesClassPath)));
                }
                Set<String> classNames = compiledFiles.keySet();
                StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, classNames.size() > 1 ? "Classes {} have been succesfully compiled" : "Class {} has been succesfully compiled", classNames.size() > 1 ? String.join((CharSequence)", ", classNames) : classNames.stream().findFirst().orElseGet(() -> ""));
                JavaMemoryCompiler.Compilation.Result result = new JavaMemoryCompiler.Compilation.Result(storedFilesClassPath != null ? FileSystemItem.ofPath(storedFilesClassPath) : null, compiledFiles, new HashSet<String>(context.classPaths));
                return result;
            }
        });
        return (QueuedTaskExecutor.ProducerTask)tsk.submit();
    }

    private String retrieveCompiledClassesStorage(String compiledClassesStorage, boolean useTemporaryFolderForStoring) {
        String storedFilesClassPath = null;
        if (compiledClassesStorage != null) {
            storedFilesClassPath = useTemporaryFolderForStoring ? this.compiledClassesRepository.getAbsolutePath() + "/" + compiledClassesStorage : compiledClassesStorage;
        }
        return storedFilesClassPath;
    }

    private void sourcesToMemorySources(Collection<String> sources, Collection<MemorySource> memorySources) {
        for (String source : sources) {
            String className = StaticComponentContainer.SourceCodeHandler.extractClassName(source);
            try {
                memorySources.add(new MemorySource(JavaFileObject.Kind.SOURCE, className, source));
            }
            catch (URISyntaxException exc) {
                throw new JavaMemoryCompiler.Compilation.Exception(StaticComponentContainer.Strings.compile("Class name \"{}\" is not valid", className), exc);
            }
        }
    }

    private Map<String, ByteBuffer> compile(Compilation.Context context) {
        if (!context.classPaths.isEmpty()) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "... Using class paths:\n\t{}", String.join((CharSequence)"\n\t", context.classPaths));
        }
        ArrayList<String> options = new ArrayList<String>();
        if (!context.options.isEmpty()) {
            context.options.forEach((key, val) -> {
                options.add((String)key);
                Optional.ofNullable(val).ifPresent(value -> options.add((String)value));
            });
        }
        DiagnosticListener diagnosticListener = new DiagnosticListener(context);
        try (MemoryFileManager memoryFileManager = new MemoryFileManager(this.compiler.getStandardFileManager(diagnosticListener, null, null));){
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, memoryFileManager, new DiagnosticListener(context), options, null, new ArrayList<MemorySource>(context.sources));
            boolean done = false;
            try {
                done = task.call();
            }
            catch (Throwable currentException) {
                Throwable previousException = context.getPreviousException();
                if (previousException != null && previousException.getMessage().equals(currentException.getMessage())) {
                    throw currentException;
                }
                context.setPreviousException(currentException);
            }
            if (!done) {
                Map<String, ByteBuffer> map = this.compile(context);
                return map;
            }
            Map<String, ByteBuffer> map = memoryFileManager.getCompiledFiles().stream().collect(Collectors.toMap(compiledFile -> compiledFile.getName(), compiledFile -> compiledFile.toByteBuffer()));
            return map;
        }
    }

    @Override
    public void close() {
        this.closeResources(() -> this.compiledClassesRepository == null, task -> {
            this.compiledClassesRepository.destroy();
            this.compiledClassesRepository = null;
            this.compiler = null;
            this.pathHelper = null;
        });
    }

    static class MemorySource
    extends SimpleJavaFileObject
    implements Serializable {
        private static final long serialVersionUID = 4669403234662034315L;
        private final String content;
        private final String name;
        static final String PREFIX = "memo:///";

        public MemorySource(JavaFileObject.Kind kind, String name, String content) throws URISyntaxException {
            super(new URI(PREFIX + name.replace('.', '/') + kind.extension), kind);
            this.name = name;
            this.content = content;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.content;
        }

        public String getContent() {
            return this.content;
        }
    }

    static class Compilation {
        Compilation() {
        }

        static class Context
        implements Closeable {
            Collection<String> classPaths;
            Collection<String> blackListedClassPaths;
            Map<String, String> options;
            Collection<MemorySource> sources;
            private Collection<String> classRepositories;
            private JavaMemoryCompiler javaMemoryCompiler;
            private Throwable previousException;
            private Collection<String> diagnositListenerInterceptedMessages;

            private Context(JavaMemoryCompiler javaMemoryCompiler, Collection<MemorySource> sources, Collection<String> classPaths, Collection<String> classRepositories, Collection<String> blackListedClassPaths, Map<String, String> extraOptions) {
                this.javaMemoryCompiler = javaMemoryCompiler;
                this.options = new LinkedHashMap<String, String>();
                if (extraOptions != null) {
                    this.options.putAll(extraOptions);
                }
                this.classPaths = new HashSet<String>();
                this.blackListedClassPaths = new HashSet<String>(blackListedClassPaths);
                this.sources = sources;
                if (classPaths != null) {
                    for (String classPath : classPaths) {
                        this.addToClassPath(classPath);
                    }
                }
                this.classRepositories = classRepositories;
                this.diagnositListenerInterceptedMessages = new HashSet<String>();
            }

            static Context create(JavaMemoryCompiler javaMemoryCompiler, Collection<MemorySource> sources, Collection<String> classPaths, Collection<String> classRepositories, Collection<String> blackListedClassPaths, Map<String, String> extraOptions) {
                return new Context(javaMemoryCompiler, sources, classPaths, classRepositories, blackListedClassPaths, extraOptions);
            }

            void addToClassPath(String path) {
                if (StaticComponentContainer.Strings.isNotBlank(path)) {
                    if (this.blackListedClassPaths.contains(path)) {
                        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not add {} to class path because it is black listed", path);
                        return;
                    }
                    String classPath = StaticComponentContainer.Paths.clean(path);
                    this.options.put("-classpath", Optional.ofNullable(this.options.get("-classpath")).orElse("") + classPath + File.pathSeparator);
                    this.classPaths.add(classPath);
                }
            }

            Collection<String> findForPackageName(String packageName) throws Exception {
                HashSet<String> classPaths = new HashSet<String>(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).classPathHelper.compute(ClassPathHelper.Compute.Config.create(Arrays.asList(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).compiledClassesRepository.getAbsolutePath())).refreshAllPathsThat(fileSystemItem -> fileSystemItem.getAbsolutePath().equals(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).compiledClassesRepository.getAbsolutePath())).withFileFilter(classFile -> Objects.equals(classFile.toJavaClass().getPackageName(), packageName))).get().values());
                if (classPaths.isEmpty()) {
                    classPaths.addAll(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).classPathHelper.compute(ClassPathHelper.Compute.BySourceImportsConfig.create(this.sources.stream().map(ms -> ms.getContent()).collect(Collectors.toCollection(HashSet::new)), this.classRepositories).withAdditionalFileFilter(classFile -> Objects.equals(classFile.toJavaClass().getPackageName(), packageName))).get().values());
                }
                return classPaths;
            }

            Collection<String> findForClassName(Predicate<JavaClass> classPredicate) throws Exception {
                HashSet<String> classPaths = new HashSet<String>(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).classPathHelper.compute(ClassPathHelper.Compute.Config.create(Arrays.asList(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).compiledClassesRepository.getAbsolutePath())).refreshAllPathsThat(fileSystemItem -> fileSystemItem.getAbsolutePath().equals(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).compiledClassesRepository.getAbsolutePath())).withFileFilter(classFile -> classPredicate.test(classFile.toJavaClass()))).get().values());
                if (classPaths.isEmpty()) {
                    classPaths.addAll(((JavaMemoryCompilerImpl)this.javaMemoryCompiler).classPathHelper.compute(ClassPathHelper.Compute.BySourceImportsConfig.create(this.sources.stream().map(ms -> ms.getContent()).collect(Collectors.toCollection(HashSet::new)), this.classRepositories).withAdditionalFileFilter(classFile -> classPredicate.test(classFile.toJavaClass()))).get().values());
                }
                return classPaths;
            }

            void setPreviousException(Throwable previousException) {
                this.previousException = previousException;
            }

            Throwable getPreviousException() {
                return this.previousException;
            }

            @Override
            public void close() {
                this.options.clear();
                this.options = null;
                this.classPaths.clear();
                this.classPaths = null;
                this.sources = null;
                this.classRepositories.clear();
                this.classRepositories = null;
                this.javaMemoryCompiler = null;
                this.diagnositListenerInterceptedMessages.clear();
                this.diagnositListenerInterceptedMessages = null;
            }
        }
    }

    static class DiagnosticListener
    implements javax.tools.DiagnosticListener<JavaFileObject>,
    Serializable,
    Component {
        private static final long serialVersionUID = 4404913684967693355L;
        private Compilation.Context context;

        DiagnosticListener(Compilation.Context context) {
            this.context = context;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            String packageName;
            String message = diagnostic.getMessage(Locale.ENGLISH);
            if (this.context.diagnositListenerInterceptedMessages.contains(message)) {
                throw new JavaMemoryCompiler.Compilation.Exception(message);
            }
            this.context.diagnositListenerInterceptedMessages.add(message);
            if (message.contains("unchecked or unsafe operations") || message.contains("Recompile with -Xlint:unchecked")) {
                this.context.options.put("-Xlint:", "unchecked");
                return;
            }
            Collection<String> fsObjects = null;
            String classNameOrSimpleNameTemp = null;
            Predicate<JavaClass> javaClassPredicate = null;
            if (message.indexOf("class file for") != -1 && message.indexOf("not found") != -1) {
                classNameOrSimpleNameTemp = message.substring(message.indexOf("for ") + 4);
                String className = classNameOrSimpleNameTemp = classNameOrSimpleNameTemp.substring(0, classNameOrSimpleNameTemp.indexOf(" "));
                javaClassPredicate = cls -> cls.getName().equals(className);
            } else if (message.indexOf("class ") != -1 && message.indexOf("package ") != -1) {
                classNameOrSimpleNameTemp = message.substring(message.indexOf("class ") + 6);
                classNameOrSimpleNameTemp = classNameOrSimpleNameTemp.substring(0, classNameOrSimpleNameTemp.indexOf("\n"));
                packageName = message.substring(message.indexOf("package") + 8);
                String className = packageName + "." + classNameOrSimpleNameTemp;
                javaClassPredicate = cls -> cls.getName().equals(className);
            } else if (message.indexOf("symbol: class") != -1) {
                String classSimpleName = classNameOrSimpleNameTemp = message.substring(message.indexOf("class ") + 6);
                javaClassPredicate = cls -> cls.getSimpleName().equals(classSimpleName);
            }
            if (javaClassPredicate != null) {
                try {
                    fsObjects = this.context.findForClassName(javaClassPredicate);
                }
                catch (Exception exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                }
            } else {
                int firstOccOfSpaceIdx;
                packageName = null;
                if (message.indexOf("package exists in another module") == -1 && message.indexOf("cannot be accessed from outside package") == -1 && message.indexOf("package ") != -1 && (firstOccOfSpaceIdx = (packageName = message.substring(message.indexOf("package") + 8)).indexOf(" ")) != -1) {
                    packageName = packageName.substring(0, firstOccOfSpaceIdx);
                }
                if (StaticComponentContainer.Strings.isNotEmpty(packageName)) {
                    try {
                        fsObjects = this.context.findForPackageName(packageName);
                    }
                    catch (Exception exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    }
                } else {
                    throw new JavaMemoryCompiler.Compilation.Exception(message);
                }
            }
            if (fsObjects == null || fsObjects.isEmpty()) {
                String classNameOrSimpleName = classNameOrSimpleNameTemp;
                throw new JavaMemoryCompiler.Compilation.Exception(Optional.ofNullable(javaClassPredicate).map(jCP -> "Class or package \"" + classNameOrSimpleName + "\" not found").orElseGet(() -> message));
            }
            fsObjects.forEach(fsObject -> this.context.addToClassPath((String)fsObject));
        }
    }

    static class MemoryFileManager
    extends ForwardingJavaFileManager
    implements Component,
    StandardJavaFileManager {
        private List<MemoryFileObject> compiledFiles;
        private StandardJavaFileManager javaFileManager;

        MemoryFileManager(StandardJavaFileManager javaFileManager) {
            super(javaFileManager);
            this.javaFileManager = javaFileManager;
            this.compiledFiles = new CopyOnWriteArrayList<MemoryFileObject>();
        }

        @Override
        public MemoryFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            MemoryFileObject mc = new MemoryFileObject(name, kind);
            this.compiledFiles.add(mc);
            return mc;
        }

        List<MemoryFileObject> getCompiledFiles() {
            return this.compiledFiles;
        }

        @Override
        public void close() {
            this.compiledFiles.forEach(compiledFile -> compiledFile.close());
            this.compiledFiles.clear();
            Executor.run(() -> super.close());
            this.javaFileManager = null;
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
            return this.javaFileManager.getJavaFileObjectsFromFiles(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
            return this.javaFileManager.getJavaFileObjects(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
            return this.javaFileManager.getJavaFileObjectsFromStrings(names);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
            return this.javaFileManager.getJavaFileObjects(names);
        }

        @Override
        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> paths) throws IOException {
            try {
                this.javaFileManager.setLocation(location, paths);
            }
            catch (IllegalArgumentException exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, exc.getMessage());
            }
        }

        @Override
        public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
            return this.javaFileManager.getLocation(location);
        }
    }

    static class MemoryFileObject
    extends SimpleJavaFileObject
    implements Component {
        private String name;
        private ByteBuffer content;

        MemoryFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("memory:///" + name.replace('.', '/') + kind.extension), kind);
            this.name = name;
        }

        public String getPath() {
            return this.uri.getPath();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ByteBuffer toByteBuffer() {
            return StaticComponentContainer.BufferHandler.shareContent(this.content);
        }

        public byte[] toByteArray() {
            return StaticComponentContainer.BufferHandler.toByteArray(this.content);
        }

        @Override
        public OutputStream openOutputStream() {
            return new ByteBufferOutputStream(StaticComponentContainer.BufferHandler.getDefaultBufferSize()){

                @Override
                public void close() {
                    content = this.toByteBuffer();
                    super.close();
                }
            };
        }

        @Override
        public void close() {
            this.name = null;
            this.content = null;
        }
    }
}

