/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.annotation.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionDriver;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionIntrospectionStrategy;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.error.ShouldNotSatisfyPredicateRecursively;

@Beta
public class RecursiveAssertionAssert
extends AbstractAssert<RecursiveAssertionAssert, Object> {
    private final RecursiveAssertionConfiguration recursiveAssertionConfiguration;
    private final RecursiveAssertionDriver recursiveAssertionDriver;

    public RecursiveAssertionAssert(Object o, RecursiveAssertionConfiguration recursiveAssertionConfiguration) {
        super(o, RecursiveAssertionAssert.class);
        this.recursiveAssertionConfiguration = recursiveAssertionConfiguration;
        this.recursiveAssertionDriver = new RecursiveAssertionDriver(recursiveAssertionConfiguration);
    }

    public RecursiveAssertionAssert allFieldsSatisfy(Predicate<Object> predicate) {
        this.recursiveAssertionDriver.reset();
        List<FieldLocation> failedFields = this.recursiveAssertionDriver.assertOverObjectGraph(predicate, this.actual);
        if (!failedFields.isEmpty()) {
            throw this.objects.getFailures().failure((AssertionInfo)this.info, ShouldNotSatisfyPredicateRecursively.shouldNotSatisfyRecursively(this.recursiveAssertionConfiguration, failedFields));
        }
        return this;
    }

    public RecursiveAssertionAssert hasNoNullFields() {
        return this.allFieldsSatisfy(Objects::nonNull);
    }

    public RecursiveAssertionAssert ignoringFields(String ... fieldsToIgnore) {
        this.recursiveAssertionConfiguration.ignoreFields(fieldsToIgnore);
        return this;
    }

    public RecursiveAssertionAssert ignoringFieldsMatchingRegexes(String ... regexes) {
        this.recursiveAssertionConfiguration.ignoreFieldsMatchingRegexes(regexes);
        return this;
    }

    public RecursiveAssertionAssert ignoringFieldsOfTypes(Class<?> ... typesToIgnore) {
        this.recursiveAssertionConfiguration.ignoreFieldsOfTypes(typesToIgnore);
        return this;
    }

    public RecursiveAssertionAssert ignoringPrimitiveFields() {
        this.recursiveAssertionConfiguration.ignorePrimitiveFields(true);
        return this;
    }

    public RecursiveAssertionAssert ignoringAllNullFields() {
        this.recursiveAssertionConfiguration.ignoreAllNullFields(true);
        return this;
    }

    public RecursiveAssertionAssert withOptionalAssertionPolicy(RecursiveAssertionConfiguration.OptionalAssertionPolicy optionalAssertionPolicy) {
        this.recursiveAssertionConfiguration.setOptionalAssertionPolicy(optionalAssertionPolicy);
        return this;
    }

    public RecursiveAssertionAssert withCollectionAssertionPolicy(RecursiveAssertionConfiguration.CollectionAssertionPolicy collectionAssertionPolicy) {
        this.recursiveAssertionConfiguration.setCollectionAssertionPolicy(collectionAssertionPolicy);
        return this;
    }

    public RecursiveAssertionAssert withMapAssertionPolicy(RecursiveAssertionConfiguration.MapAssertionPolicy mapAssertionPolicy) {
        this.recursiveAssertionConfiguration.setMapAssertionPolicy(mapAssertionPolicy);
        return this;
    }

    public RecursiveAssertionAssert withIntrospectionStrategy(RecursiveAssertionIntrospectionStrategy introspectionStrategy) {
        this.recursiveAssertionConfiguration.setIntrospectionStrategy(introspectionStrategy);
        return this;
    }
}

