/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.FormatterUIPlugin;
import org.eclipse.php.formatter.ui.Logger;
import org.eclipse.php.formatter.ui.preferences.ProfileManager;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.php.ui.formatterprofiles";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final List<ProfileManager.Profile> EMPTY_PROFILES = Collections.emptyList();

    private ProfileStore() {
    }

    public static List<ProfileManager.Profile> readProfiles(IScopeContext scope) throws CoreException {
        List<ProfileManager.Profile> res = ProfileStore.readProfilesFromPreferences(scope);
        if (res == null) {
            return ProfileStore.readOldForCompatibility(scope);
        }
        return res;
    }

    public static void writeProfiles(Collection<ProfileManager.Profile> profiles, IScopeContext instanceScope) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            try {
                String val;
                ProfileStore.writeProfilesToStream(profiles, stream);
                try {
                    val = stream.toString("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    val = stream.toString();
                }
                IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.php.formatter.core");
                uiPreferences.put(PREF_FORMATTER_PROFILES, val);
                uiPreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<ProfileManager.Profile> readProfilesFromPreferences(IScopeContext scope) throws CoreException {
        String string = scope.getNode("org.eclipse.php.formatter.core").get(PREF_FORMATTER_PROFILES, null);
        if (string != null && string.length() > 0) {
            byte[] bytes;
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = string.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List<ProfileManager.Profile> res;
                List<ProfileManager.Profile> list = res = ProfileStore.readProfilesFromStream(new InputSource(is));
                return list;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static List<ProfileManager.Profile> readOldForCompatibility(IScopeContext instanceScope) {
        block8: {
            List<ProfileManager.Profile> list;
            String STORE_FILE = "code_formatter_profiles.xml";
            File file = FormatterUIPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            try {
                List<ProfileManager.Profile> res = ProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    ProfileStore.writeProfiles(res, instanceScope);
                }
                file.delete();
                list = res;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    break block8;
                }
                catch (IOException e) {
                    Logger.logException(e);
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    public static List<ProfileManager.Profile> readProfilesFromFile(File file) throws CoreException {
        List<ProfileManager.Profile> list;
        FileInputStream reader = new FileInputStream(file);
        try {
            list = ProfileStore.readProfilesFromStream(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private static List<ProfileManager.Profile> readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        return handler.getProfiles();
    }

    public static void writeProfilesToFile(Collection<ProfileManager.Profile> profiles, File file) throws CoreException {
        try {
            FileOutputStream writer = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, writer);
            }
            finally {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static void writeProfilesToStream(Collection<ProfileManager.Profile> profiles, OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            document.appendChild(rootElement);
            for (ProfileManager.Profile profile : profiles) {
                if (!profile.isProfileToSave()) continue;
                Element profileElement = ProfileStore.createProfileElement(profile, document);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        for (String key : ProfileManager.getKeys()) {
            String value = (String)profile.getSettings().get(key);
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                element.appendChild(setting);
                continue;
            }
            Logger.log(4, "ProfileStore: Profile does not contain value for key " + key);
        }
        return element;
    }

    public static void checkCurrentOptionsVersion() {
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        try {
            ProfileManager manager;
            List<ProfileManager.Profile> profiles = ProfileStore.readProfiles(instanceScope);
            if (profiles == null) {
                profiles = EMPTY_PROFILES;
            }
            if ((manager = new ProfileManager(profiles, instanceScope)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges(instanceScope);
            }
            ProfileStore.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                ProjectScope scope = new ProjectScope(projects[i]);
                if (ProfileManager.hasProjectSpecificSettings((IScopeContext)scope)) {
                    manager = new ProfileManager(profiles, (IScopeContext)scope);
                    manager.commitChanges((IScopeContext)scope);
                    ProfileStore.savePreferences((IScopeContext)scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    private static void savePreferences(IScopeContext context) throws BackingStoreException {
        context.getNode("org.eclipse.php.formatter.core").flush();
    }

    private static CoreException createException(Throwable t, String message) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.php.formatter.ui", 4, message, t));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List<ProfileManager.Profile> fProfiles;
        private String fName;
        private Map<String, Object> fSettings;

        private ProfileDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fSettings = new HashMap<String, Object>(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList<ProfileManager.Profile>();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings));
                this.fName = null;
                this.fSettings = null;
            }
        }

        public List<ProfileManager.Profile> getProfiles() {
            return this.fProfiles;
        }
    }
}

