/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.wizards.NewPackageCreationWizard;
import org.eclipse.dltk.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;

public class CreateTargetQueries
implements ICreateTargetQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public CreateTargetQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public CreateTargetQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    @Override
    public ICreateTargetQuery createNewPackageQuery() {
        return new ICreateTargetQuery(){

            @Override
            public Object getCreatedTarget(Object selection) {
                NewPackageCreationWizard packageCreationWizard = new NewPackageCreationWizard(){

                    @Override
                    protected NewPackageWizardPage createNewPackageWizardPage() {
                        return new NewPackageWizardPage(){

                            @Override
                            protected String getRequiredNature() {
                                if (DLTKCore.DEBUG) {
                                    System.err.println("TODO: Add correct create new package for move case.");
                                }
                                return null;
                            }
                        };
                    }
                };
                IWizardPage[] pages = CreateTargetQueries.this.openNewElementWizard((IWorkbenchWizard)packageCreationWizard, CreateTargetQueries.this.getShell(), selection);
                NewPackageWizardPage page = (NewPackageWizardPage)pages[0];
                return page.getNewScriptFolder();
            }

            @Override
            public String getNewButtonLabel() {
                return ReorgMessages.ReorgMoveWizard_newPackage;
            }
        };
    }

    private IWizardPage[] openNewElementWizard(IWorkbenchWizard wizard, Shell shell, Object selection) {
        wizard.init(DLTKUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection(selection));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
        IWizardPage[] pages = wizard.getPages();
        return pages;
    }
}

