/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.core.gef.part.menu.MenuReference;
import org.eclipse.wb.internal.core.gef.part.menu.SubmenuAwareEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;

public final class MenuPopupEditPart
extends SubmenuAwareEditPart {
    private final IMenuPopupInfo m_popup;
    private IMenuInfo m_menuObject;
    private MenuReference m_menuReference;

    public MenuPopupEditPart(Object toolkitModel, IMenuPopupInfo popup) {
        super(toolkitModel, popup);
        this.m_popup = popup;
    }

    @Override
    protected Figure createFigure() {
        return new Figure(){

            @Override
            protected void paintClientArea(Graphics graphics) {
                ImageDescriptor imageDescriptor = MenuPopupEditPart.this.m_popup.getImageDescriptor();
                if (imageDescriptor != null) {
                    Image image = imageDescriptor.createImage();
                    graphics.drawImage(image, 0, 0);
                    image.dispose();
                }
                if (!MenuPopupEditPart.this.getModelChildren().isEmpty()) {
                    Rectangle area = MenuPopupEditPart.this.getFigure().getClientArea();
                    graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
                    graphics.setBackgroundColor(ColorConstants.white);
                    graphics.setLineWidth(2);
                    graphics.drawRectangle(1, 1, area.width - 2, area.height - 2);
                }
            }
        };
    }

    @Override
    protected void refreshVisuals() {
        this.getFigure().setBounds(this.m_popup.getBounds());
    }

    @Override
    protected Object getChildMenu() {
        IMenuInfo menu = this.m_popup.getMenu();
        if (menu != this.m_menuObject) {
            this.m_menuObject = menu;
            this.m_menuReference = new MenuReference(menu);
        }
        return this.m_menuReference;
    }
}

